/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.repos;

import com.atlassian.stash.commit.CommitDiscussion;
import com.atlassian.stash.commit.CommitDiscussionCommentAnchor;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetsBetweenRequest;
import com.atlassian.stash.content.ContentService;
import com.atlassian.stash.content.ContentTreeCallback;
import com.atlassian.stash.content.ContentTreeNode;
import com.atlassian.stash.content.DirRevisionTreeCallback;
import com.atlassian.stash.content.DirectoryRevision;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.content.Path;
import com.atlassian.stash.content.SimplePath;
import com.atlassian.stash.exception.NoDefaultBranchException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.commit.InternalCommitService;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.web.repos.PathParts;
import com.atlassian.stash.internal.web.repos.ViewFile;
import com.atlassian.stash.internal.web.repos.ViewRef;
import com.atlassian.stash.internal.web.repos.ViewRefType;
import com.atlassian.stash.internal.web.repos.ViewRefTypeHelper;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.internal.web.util.DownloadHeaderHelper;
import com.atlassian.stash.internal.web.util.RepositoryControllerSupport;
import com.atlassian.stash.io.TypeAwareOutputSupplier;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryMetadataService;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.repository.Tag;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriUtils;

@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}"})
public class RepositoryController
extends RepositoryControllerSupport {
    static final String BRANCH_LIST = "stash.page.branches";
    static final String FILE_BROWSER = "stash.page.filebrowser";
    static final String COMMIT_LIST = "stash.page.commits";
    static final String COMMIT_LIST_FRAGMENT = "stash.feature.commits.commitsTable";
    static final String CHANGESET = "stash.page.changeset";
    static final String SOURCE_VIEW = "stash.page.source";
    static final String NO_DEFAULT_BRANCH_VIEW = "stash.page.noDefaultBranch";
    static final String FILES_TAB = "stash.repository.nav.files";
    static final String COMMITS_TAB = "stash.repository.nav.commits";
    @Value(value="${page.max.directory.children}")
    private int maxDirectoryChildren;
    @Value(value="${page.max.changes}")
    private int maxChanges;
    @Value(value="${commit.diff.context}")
    private int relevantContextLines;
    private final InternalCommitService commitService;
    private final DownloadHeaderHelper downloadHeaderHelper;
    private final ContentService contentService;
    private final NavBuilder navBuilder;
    private final ViewRefTypeHelper viewRefTypeHelper;

    @Autowired
    public RepositoryController(I18nService i18nService, InternalProjectService projectService, RepositoryService repositoryService, RepositoryMetadataService metadataService, InternalCommitService commitService, ContentService contentService, DownloadHeaderHelper downloadHeaderHelper, NavBuilder navBuilder, PermissionService permissionService, ViewRefTypeHelper viewRefTypeHelper) {
        super(i18nService, projectService, repositoryService, metadataService, permissionService);
        this.commitService = commitService;
        this.downloadHeaderHelper = downloadHeaderHelper;
        this.contentService = contentService;
        this.navBuilder = navBuilder;
        this.viewRefTypeHelper = viewRefTypeHelper;
    }

    @RequestMapping(method={RequestMethod.GET})
    public RedirectView repositoryOverview(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        return new RedirectView(this.navBuilder.project(projectKey).repo(repoSlug).browse().buildRelNoContext(), true);
    }

    @RequestMapping(value={"/branches"}, method={RequestMethod.GET})
    public ModelAndView getBranches(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="base", required=false) String baseRefId) {
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        Branch defaultBranch = this.metadataService.getDefaultBranch(repository);
        ViewRef baseRef = this.toViewRef(repository, defaultBranch, baseRefId);
        String error = "";
        if (!baseRef.getType().isBranch() && !baseRef.getType().isTag()) {
            error = this.i18nService.createKeyedMessage("stash.web.branch.error.invalidBaseRef", new Object[]{baseRefId, repository.getName()}).getLocalisedMessage();
            baseRef = this.toViewRef(repository, defaultBranch, "");
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(BRANCH_LIST).putRepository(repository).put("baseRef", (Object)baseRef)).put("error", (Object)error)).build();
    }

    @RequestMapping(value={"/commits"}, method={RequestMethod.GET})
    public ModelAndView getCommits(WebRequest request, @PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="until", required=false) String untilId, @RequestParam(value="since", required=false) String sinceId, @RequestParam(value="expand", required=false) String[] expandAttributes, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="50") int limit, @RequestParam(value="contents", required=false, defaultValue="false") boolean contentsOnly) {
        Page changesetPage;
        Branch defaultBranch;
        Repository repository;
        block6: {
            repository = this.getRepository(projectKey, repoSlug);
            if (this.isEmptyRepository(repository)) {
                return this.handleEmptyRepo(repository);
            }
            defaultBranch = null;
            try {
                defaultBranch = this.metadataService.getDefaultBranch(repository);
            }
            catch (NoDefaultBranchException e) {
                if (!StringUtils.isBlank((String)untilId)) break block6;
                return this.handleNoDefaultBranch(repository, e.getBranchName(), COMMITS_TAB);
            }
        }
        ViewRef untilRevisionRef = this.toViewRef(repository, defaultBranch, untilId);
        String error = "";
        if (untilRevisionRef.getLatestChangeset() == null) {
            error = this.i18nService.createKeyedMessage("stash.web.commit.error.invalidUntilId", new Object[]{untilId, repository.getName()}).getLocalisedMessage();
            untilRevisionRef = this.toViewRef(repository, defaultBranch, "");
        }
        PageRequest pageRequest = PageUtils.newRequest((int)start, (int)limit);
        if (untilId != null & sinceId != null) {
            ChangesetsBetweenRequest changesetsBetween = new ChangesetsBetweenRequest.Builder(repository).exclude(sinceId, new String[0]).include(untilId, new String[0]).loadAttributes((Iterable)this.getExpandAttributes(expandAttributes)).secondaryRepository(this.getSecondaryRepository(request, repository)).build();
            changesetPage = this.commitService.getChangesetsBetween(changesetsBetween, pageRequest);
        } else {
            changesetPage = this.commitService.getChangesets(repository, untilRevisionRef.getId(), null, this.getExpandAttributes(expandAttributes), pageRequest);
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(contentsOnly ? COMMIT_LIST_FRAGMENT : COMMIT_LIST).put("changesetPage", (Object)changesetPage)).put("error", (Object)error)).putAtRef(untilRevisionRef).putRepository(repository).build();
    }

    private Collection<String> getExpandAttributes(String[] attributes) {
        if (attributes == null || attributes.length == 0) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])attributes);
    }

    @RequestMapping(value={"/commits"}, method={RequestMethod.GET}, params={"contents"})
    ModelAndView getCommitListContents(WebRequest request, @PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="until", required=false) String untilId, @RequestParam(value="since", required=false) String sinceId, @RequestParam(value="expand", required=false) String[] expandAttributes, @RequestParam(value="start", required=false, defaultValue="0") int start, @RequestParam(value="limit", required=false, defaultValue="25") int limit) {
        return this.getCommits(request, projectKey, repoSlug, untilId, sinceId, expandAttributes, start, limit, true);
    }

    @RequestMapping(value={"/commits/**"}, method={RequestMethod.GET})
    public ModelAndView getCommit(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="commitHash") String commitHash, @RequestParam(value="to", required=false) String parentId, @RequestParam(value="expand", required=false) String[] expandAttributes) {
        return this.getCommit(projectKey, repoSlug, commitHash, parentId, expandAttributes, false);
    }

    @RequestMapping(value={"/commits/**"}, method={RequestMethod.GET}, params={"commentId"})
    public ModelAndView getCommitByComment(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="commitHash") String commitHash, @RequestParam(value="commentId") long commentId) {
        commitHash = this.decode(commitHash);
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        NavBuilder.Changeset commitNav = this.navBuilder.project(projectKey).repo(repoSlug).changeset(commitHash);
        CommitDiscussion discussion = this.commitService.findDiscussionById(repository, commitHash);
        if (discussion == null) {
            return new ModelAndView("redirect:" + commitNav.buildRelNoContext());
        }
        CommitDiscussionCommentAnchor anchor = this.commitService.getAnchorByComment(discussion, commentId);
        if (anchor == null) {
            return new ModelAndView("redirect:" + commitNav.buildRelNoContext());
        }
        return new ModelAndView("redirect:" + commitNav.change((Path)new SimplePath((CharSequence)anchor.getPath())).buildRelNoContext());
    }

    @RequestMapping(value={"/commits/**"}, method={RequestMethod.GET}, params={"unwatch"})
    public ModelAndView unwatchCommit(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="commitHash") String commitHash, @RequestParam(value="to", required=false) String parentId, @RequestParam(value="expand", required=false) String[] expandAttributes) {
        return this.getCommit(projectKey, repoSlug, commitHash, parentId, expandAttributes, true);
    }

    @RequestMapping(value={"/browse/**"}, method={RequestMethod.GET})
    public ModelAndView browseFilePath(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="path", defaultValue="") String filePath, @RequestParam(value="at", required=false) String objectId, @RequestParam(value="until", required=false) String untilRevisionId) {
        Branch defaultBranch;
        filePath = this.decode(filePath);
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        Project project = repository.getProject();
        try {
            defaultBranch = this.metadataService.getDefaultBranch(repository);
        }
        catch (NoDefaultBranchException e) {
            if (StringUtils.isBlank((String)objectId)) {
                return this.handleNoDefaultBranch(repository, e.getBranchName(), FILES_TAB);
            }
            defaultBranch = null;
        }
        SimplePath path = new SimplePath((CharSequence)filePath);
        ViewRef atRevision = this.toViewRef(repository, defaultBranch, objectId);
        ViewRef untilRevision = StringUtils.isBlank((String)untilRevisionId) ? null : this.toViewRef(repository, defaultBranch, untilRevisionId);
        try {
            if (this.contentService.getType(repository, this.getFileRevision(untilRevision, atRevision), filePath) == ContentTreeNode.Type.DIRECTORY) {
                if (untilRevision == null) {
                    return this.handleDirectory(project, repository, filePath, atRevision);
                }
                return new ModelAndView("redirect:" + this.navBuilder.project(project).repo(repository).browse().atRevision(atRevision.isDefault() ? null : atRevision.getDisplayId()).path((Path)path).buildRelNoContext());
            }
            List pathParts = this.getPathParts(path, project, repository, atRevision);
            return this.handleFile(repository, (Path)path, (Iterable)pathParts, atRevision, untilRevision, false);
        }
        catch (NoSuchEntityException e) {
            return this.handleNonExistentDir(project, repository, filePath, atRevision, e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/diff/**"}, method={RequestMethod.GET})
    public ModelAndView diffFilePath(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="path", defaultValue="") String filePath, @RequestParam(value="at", required=false) String objectId, @RequestParam(value="until", required=false) String untilRevisionId) {
        Branch defaultBranch;
        filePath = this.decode(filePath);
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        Project project = repository.getProject();
        try {
            defaultBranch = this.metadataService.getDefaultBranch(repository);
        }
        catch (NoDefaultBranchException e) {
            if (StringUtils.isBlank((String)objectId)) {
                return this.handleNoDefaultBranch(repository, e.getBranchName(), FILES_TAB);
            }
            defaultBranch = null;
        }
        SimplePath path = new SimplePath((CharSequence)filePath);
        ViewRef atRevision = this.toViewRef(repository, defaultBranch, objectId);
        ViewRef untilRevision = StringUtils.isBlank((String)untilRevisionId) ? null : this.toViewRef(repository, defaultBranch, untilRevisionId);
        try {
            if (this.contentService.getType(repository, this.getFileRevision(untilRevision, atRevision), filePath) == ContentTreeNode.Type.FILE) {
                List pathParts = this.getPathParts(path, project, repository, atRevision);
                return this.handleFile(repository, (Path)path, (Iterable)pathParts, atRevision, untilRevision, true);
            }
            return new ModelAndView("redirect:" + this.navBuilder.project(project).repo(repository).browse().atRevision(atRevision.isDefault() ? null : atRevision.getDisplayId()).path((Path)path).buildRelNoContext());
        }
        catch (NoSuchEntityException e) {
            return this.handleNonExistentDir(project, repository, filePath, untilRevision != null ? untilRevision : atRevision, e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/browse/**"}, method={RequestMethod.GET}, params={"raw"})
    public void browseRawFilePath(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug, @RequestParam(value="path", defaultValue="") String filePath, @RequestParam(value="at", required=false) String objectId, @RequestHeader(value="User-Agent", required=false) String userAgent, HttpServletResponse response) throws IOException {
        String decodedFilePath = this.decode(filePath);
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return;
        }
        if (StringUtils.isBlank((String)objectId)) {
            objectId = this.metadataService.getDefaultBranch(repository).getLatestChangeset();
        }
        SimplePath path = new SimplePath((CharSequence)decodedFilePath);
        this.contentService.streamFile(repository, objectId, path.toString(), (TypeAwareOutputSupplier)new /* Unavailable Anonymous Inner Class!! */);
    }

    private ModelAndView getCommit(String projectKey, String repoSlug, String commitHash, String parentId, String[] expandAttributes, boolean unwatch) {
        commitHash = this.decode(commitHash);
        Repository repository = this.getRepository(projectKey, repoSlug);
        if (this.isEmptyRepository(repository)) {
            return this.handleEmptyRepo(repository);
        }
        Changeset changeset = this.commitService.getChangeset(repository, commitHash, this.getExpandAttributes(expandAttributes));
        StashSoyResponseBuilder builder = (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(CHANGESET).putRepository(repository).putChangeset((MinimalChangeset)changeset).put("parentId", (Object)(StringUtils.isBlank((String)parentId) && !changeset.getParents().isEmpty() ? ((MinimalChangeset)changeset.getParents().iterator().next()).getId() : parentId))).put("maxChanges", (Object)this.maxChanges)).put("relevantContextLines", (Object)this.relevantContextLines);
        if (unwatch) {
            builder.put("unwatched", (Object)this.commitService.unwatch(repository, changeset.getId()));
        }
        return ((StashSoyResponseBuilder)builder.put("commitDiscussion", (Object)this.commitService.findDiscussionById(repository, changeset.getId()))).build();
    }

    private ModelAndView handleNonExistentDir(Project project, Repository repository, String filePath, ViewRef revision, String errorMessage) {
        ArrayList files = Lists.newArrayList();
        if (StringUtils.isBlank((String)errorMessage)) {
            errorMessage = this.i18nService.getMessage("stash.web.file.table.cant.load", new Object[0]);
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)this._handleDirectoryImpl(project, repository, filePath, revision, (List)files, false).put("isError", (Object)true)).put("errorMessage", (Object)errorMessage)).build();
    }

    private ModelAndView handleDirectory(Project project, Repository repository, String filePath, ViewRef revision) {
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)this.maxDirectoryChildren);
        DirRevisionTreeCallback callback = new DirRevisionTreeCallback(filePath, repository.getName());
        this.contentService.streamDirectory(repository, revision.getId(), filePath, false, (ContentTreeCallback)callback, pageRequest);
        DirectoryRevision directoryRevisionInfo = callback.getDirRevision();
        boolean isTruncated = !directoryRevisionInfo.getChildren().getIsLastPage();
        List files = this.getSortedFilesWithUrl(directoryRevisionInfo.getChildren().getValues(), project.getKey(), repository.getSlug(), directoryRevisionInfo.getPath().toString(), revision, isTruncated);
        return this._handleDirectoryImpl(project, repository, filePath, revision, files, isTruncated).build();
    }

    private StashSoyResponseBuilder _handleDirectoryImpl(Project project, Repository repository, String filePath, ViewRef revision, List<ViewFile> files, boolean isTruncated) {
        SimplePath path = new SimplePath((CharSequence)filePath);
        List parts = this.getPathParts(path, project, repository, revision);
        String parentPath = !path.isRoot() ? this.navBuilder.project(project).repo(repository).browse().atRevision(revision.isDefault() ? null : revision.getDisplayId()).path((Path)path.getParentPath()).buildRelative() : "";
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(FILE_BROWSER).putRepository(repository).put("parentPath", (Object)path.getParent())).put("parentDirectoryUrl", (Object)parentPath)).put("files", files)).put("path", (Object)filePath)).putAtRef(revision).put("pathComponents", (Object)parts)).put("isTruncated", (Object)isTruncated)).put("maxDirectoryChildren", (Object)this.maxDirectoryChildren);
    }

    private ModelAndView handleFile(Repository repository, Path path, Iterable<PathParts> pathComponents, ViewRef atRevision, ViewRef untilRevision, boolean showDiff) {
        try {
            Changeset changeset = this.commitService.getChangeset(repository, this.getFileRevision(untilRevision, atRevision), path.toString());
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(SOURCE_VIEW).putRepository(repository).putUntilRevision(changeset).put("pathComponents", pathComponents)).put("showDiff", (Object)showDiff)).put("relevantContextLines", (Object)this.relevantContextLines)).put("path", (Object)path.toString())).putAtRef(atRevision).build();
        }
        catch (NoSuchEntityException e) {
            return this.handleNonExistentDir(repository.getProject(), repository, path.toString(), untilRevision, e.getLocalizedMessage());
        }
    }

    private ModelAndView handleNoDefaultBranch(Repository repository, String branchName, String activeTab) {
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(NO_DEFAULT_BRANCH_VIEW).putRepository(repository).putAtRef(new ViewRef(branchName, true, this.getBranchViewRefType())).put("activeNav", (Object)activeTab)).put("isRepoAdmin", (Object)this.permissionService.hasRepositoryPermission(repository, Permission.REPO_ADMIN))).build();
    }

    private List<ViewFile> getSortedFilesWithUrl(Iterable<? extends ContentTreeNode> files, String project, String repo, String parentPath, ViewRef ref, boolean isTruncated) {
        ArrayList<ViewFile> newFiles = new ArrayList<ViewFile>();
        for (ContentTreeNode contentTreeNode : files) {
            newFiles.add(ViewFile.create((ContentTreeNode)contentTreeNode, (String)project, (String)repo, (String)parentPath, (ViewRef)ref, (NavBuilder)this.navBuilder));
        }
        if (!isTruncated) {
            Collections.sort(newFiles);
        }
        return newFiles;
    }

    private List<PathParts> getPathParts(SimplePath path, Project project, Repository repo, ViewRef ref) {
        LinkedList<PathParts> breadcrumbs = new LinkedList<PathParts>();
        NavBuilder.Repo repoBuilder = this.navBuilder.project(project.getKey()).repo(repo.getSlug());
        if (!ref.isDefault()) {
            repoBuilder.withParam("at", ref.getType().isCommit() ? ref.getId() : ref.getDisplayId());
        }
        breadcrumbs.add(new PathParts(repo.getName(), repoBuilder.buildRelative()));
        while (!path.isRoot()) {
            NavBuilder.PathBuilder pathBuilder = this.navBuilder.project(project.getKey()).repo(repo.getSlug()).browse().path((Path)path);
            if (!ref.isDefault()) {
                pathBuilder.withParam("at", ref.getType().isCommit() ? ref.getId() : ref.getDisplayId());
            }
            breadcrumbs.add(1, new PathParts(path.getName(), pathBuilder.buildRelative()));
            path = path.getParentPath();
        }
        return breadcrumbs;
    }

    private ViewRef toViewRef(Repository repository, Branch defaultBranch, String originalObjectId) {
        Object ref = StringUtils.isBlank((String)originalObjectId) ? defaultBranch : this.metadataService.resolveRef(repository, originalObjectId);
        if (ref != null) {
            return new ViewRef(ref.getId(), ref.getDisplayId(), ref instanceof Branch && ref.getIsDefault(), this.getRefTypeView((Ref)ref), ref.getLatestChangeset());
        }
        return new ViewRef(originalObjectId, StringUtils.substring((String)originalObjectId, (int)0, (int)7), false, this.getRefTypeView(null));
    }

    private ViewRefType getBranchViewRefType() {
        return this.viewRefTypeHelper.getViewRefType(ViewRefType.BRANCH);
    }

    private ViewRefType getRefTypeView(Ref ref) {
        if (ref instanceof Branch) {
            return this.getBranchViewRefType();
        }
        if (ref instanceof Tag) {
            return this.viewRefTypeHelper.getViewRefType(ViewRefType.TAG);
        }
        return this.viewRefTypeHelper.getViewRefType(ViewRefType.COMMIT);
    }

    private String decode(String str) {
        try {
            return UriUtils.decode((String)str, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    private String getFileRevision(ViewRef untilRevision, ViewRef atRevision) {
        return untilRevision == null ? atRevision.getId() : untilRevision.getId();
    }

    static /* synthetic */ DownloadHeaderHelper access$000(RepositoryController x0) {
        return x0.downloadHeaderHelper;
    }
}

