/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.markup;

import com.atlassian.markup.renderer.MarkupRendererComponent;
import com.atlassian.markup.renderer.RenderContext;
import com.atlassian.markup.renderer.RenderTransform;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.idx.ChangesetIndex;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.MarkupUtils;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ChangesetMarkupRenderer
implements MarkupRendererComponent {
    private static final Pattern CSID_PATTERN = Pattern.compile("\\b[0-9a-fA-F]{7,40}\\b");
    private static final Pattern EXCLUDE_PATTERN = MarkupUtils.LINKS;
    private static final TransactionDefinition READ_ONLY_TRANSACTION = SpringTransactionUtils.definitionFor((int)0, (boolean)true);
    private final ChangesetIndex changesetIndex;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final TransactionTemplate transactionTemplate;

    public ChangesetMarkupRenderer(ChangesetIndex changesetIndex, I18nService i18nService, NavBuilder navBuilder, PlatformTransactionManager transactionManager) {
        this(changesetIndex, i18nService, navBuilder, new TransactionTemplate(transactionManager, READ_ONLY_TRANSACTION));
    }

    protected ChangesetMarkupRenderer(ChangesetIndex changesetIndex, I18nService i18nService, NavBuilder navBuilder, TransactionTemplate transactionTemplate) {
        this.changesetIndex = changesetIndex;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.transactionTemplate = transactionTemplate;
    }

    public RenderTransform process(CharSequence text, RenderContext context) {
        RenderTransform.TransformBuilder builder = RenderTransform.builder();
        Multimap matches = MarkupUtils.findMatches((CharSequence)text, (Pattern)CSID_PATTERN, (Pattern)EXCLUDE_PATTERN);
        Map repositories = this.findRepositories(matches.keySet());
        for (Map.Entry entry : repositories.entrySet()) {
            String csid = (String)entry.getKey();
            Repository repository = (Repository)entry.getValue();
            String link = this.createLink(csid, repository, context);
            Collection matchResults = matches.get((Object)csid);
            for (MatchResult match : matchResults) {
                builder.add(match.start(), match.end(), link);
            }
        }
        return builder.build();
    }

    private String createLink(String csid, Repository repository, RenderContext context) {
        String url = context.createHostUrl(this.navBuilder.repo(repository).changeset(csid).buildRelNoContext());
        String title = this.i18nService.getMessage("stash.web.markup.changeset.tooltip", new Object[]{repository.getName(), repository.getProject().getName()});
        return "<a href=\"" + url + "\" class=\"csid\" title=\"" + title + "\">" + csid + "</a>";
    }

    private Map<String, Repository> findRepositories(Set<String> csids) {
        return (Map)this.transactionTemplate.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ ChangesetIndex access$000(ChangesetMarkupRenderer x0) {
        return x0.changesetIndex;
    }
}

