/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.i18n;

import com.atlassian.stash.i18n.I18nService;
import com.google.common.base.Objects;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nMessageSource
implements MessageSource {
    public static final String[] EMPTY_STRINGS = new String[0];
    private final I18nService i18nService;

    public I18nMessageSource(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String message;
        args = (Object[])Objects.firstNonNull((Object)args, (Object)new Object[0]);
        int argCount = ArrayUtils.getLength((Object)args);
        for (int i = 0; i < argCount; ++i) {
            Object arg = args[i];
            if (!(arg instanceof MessageSourceResolvable)) continue;
            args[i] = this.getMessage((MessageSourceResolvable)arg, locale);
        }
        String string = message = locale.equals(LocaleContextHolder.getLocale()) ? this.i18nService.getText(code, defaultMessage, args) : this.i18nService.getText(locale, code, defaultMessage, args);
        if (!code.equals(message)) {
            return message;
        }
        throw new NoSuchMessageException(code, locale);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        return this.getMessage(code, args, null, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String[] codes = resolvable.getCodes();
        if (codes == null) {
            codes = EMPTY_STRINGS;
        }
        for (String code : codes) {
            try {
                String computedMessage = this.getMessage(code, resolvable.getArguments(), null, locale);
                if (code.equals(computedMessage)) continue;
                return computedMessage;
            }
            catch (NoSuchMessageException e) {
                // empty catch block
            }
        }
        if (resolvable.getDefaultMessage() != null) {
            return MessageFormat.format(resolvable.getDefaultMessage(), resolvable.getArguments());
        }
        throw new NoSuchMessageException(codes.length > 0 ? codes[codes.length - 1] : null, locale);
    }
}

