/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.filters;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="standardResponseHeadersFilter")
public class StandardResponseHeadersFilter
extends OncePerRequestFilter {
    static final String X_XSS_PROTECTION = "X-XSS-Protection";
    static final String X_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options";
    static final String X_FRAME_OPTIONS = "X-Frame-Options";
    private final Map<String, Iterable<Pattern>> whitelistByHeader = ImmutableMap.builder().put((Object)"X-Frame-Options", (Object)ImmutableList.builder().add((Object)Pattern.compile("/plugins/servlet/.*")).build()).build();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!response.containsHeader(X_XSS_PROTECTION) && !this.whitelisted(X_XSS_PROTECTION, request)) {
            response.setHeader(X_XSS_PROTECTION, "1; mode=block");
        }
        if (!response.containsHeader(X_FRAME_OPTIONS) && !this.whitelisted(X_FRAME_OPTIONS, request)) {
            response.setHeader(X_FRAME_OPTIONS, "SAMEORIGIN");
        }
        response.setHeader(X_CONTENT_TYPE_OPTIONS, "nosniff");
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean whitelisted(String header, HttpServletRequest request) {
        String url = request.getServletPath() + request.getPathInfo();
        return this.whitelistByHeader.containsKey(header) && Iterables.any((Iterable)((Iterable)this.whitelistByHeader.get(header)), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
    }
}

