/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.content;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.json.marshal.JsonableMarshaller;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/*
 * Exception performing whole class analysis ignored.
 */
public class SyntaxHighlighterDataProvider
implements WebResourceDataProvider {
    private static final Pattern SYNHI_PROPERTY = Pattern.compile("syntax\\.highlighter\\.([^.]+)\\.(extensions|executables)");
    private static final Splitter PROPERTY_SPLITTER = Splitter.on((char)',');
    public static final String EXTENSION_KEY = "e";
    public static final String EXECUTABLE_KEY = "x";
    private final JsonableMarshaller marshaller;
    private final Map<String, Map<String, Set<String>>> data;

    @Autowired
    public SyntaxHighlighterDataProvider(@Qualifier(value="applicationProperties") Properties applicationProperties, JsonableMarshaller marshaller) {
        this.marshaller = marshaller;
        this.data = SyntaxHighlighterDataProvider.findSyntaxHighlighterData((Properties)applicationProperties);
    }

    public Jsonable get() {
        return this.marshaller.marshal((Object)this.data);
    }

    private static Map<String, Map<String, Set<String>>> findSyntaxHighlighterData(Properties properties) {
        HashMap data = Maps.newHashMap();
        for (String propertyName : properties.stringPropertyNames()) {
            Matcher matcher = SYNHI_PROPERTY.matcher(propertyName);
            if (!matcher.matches()) continue;
            String highlighter = matcher.group(1);
            Map synhiConfig = (Map)data.get(highlighter);
            if (synhiConfig == null) {
                synhiConfig = Maps.newHashMap();
                data.put(highlighter, synhiConfig);
            }
            ImmutableSet values = ImmutableSet.copyOf((Iterable)PROPERTY_SPLITTER.split((CharSequence)properties.getProperty(propertyName)));
            synhiConfig.put("extensions".equals(matcher.group(2)) ? "e" : "x", values);
        }
        return data;
    }
}

