/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.avatar;

import com.atlassian.stash.avatar.AvatarStoreException;
import com.atlassian.stash.avatar.AvatarSupplier;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.avatar.AvatarForm;
import com.atlassian.stash.internal.web.avatar.AvatarLocation;
import com.atlassian.stash.internal.web.util.ControllerSupport;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.util.NumberUtils;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/tmp/avatars"})
public class TemporaryAvatarController
extends ControllerSupport {
    private final InternalAvatarService avatarService;
    private final NavBuilder navBuilder;
    private long maxSize;

    @Autowired
    public TemporaryAvatarController(I18nService i18nService, InternalAvatarService avatarService, NavBuilder navBuilder) {
        super(i18nService);
        this.avatarService = avatarService;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"{id}.png"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable(value="id") String id) {
        this.avatarService.deleteTemporary(id);
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"image/png"}, value={"{id}.png"})
    public void retrieve(@PathVariable(value="id") String id, HttpServletResponse response) throws IOException {
        AvatarSupplier supplier = this.avatarService.readTemporary(id);
        response.setContentType(supplier.getContentType());
        ByteStreams.copy((InputSupplier)supplier, (OutputStream)response.getOutputStream());
        response.flushBuffer();
    }

    @IgnoresXsrf
    @RequestMapping(consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public void save(AvatarForm avatar, HttpServletResponse response) throws IOException {
        AvatarLocation location = this.doSave(avatar);
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)location);
        response.setContentType("text/html");
        response.setStatus(201);
        response.getWriter().append("<html><body><textarea id=\"json-response\">").append(json).append("</textarea></body></html>");
        response.flushBuffer();
    }

    @IgnoresXsrf
    @RequestMapping(consumes={"multipart/form-data"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<AvatarLocation> save(AvatarForm avatar) {
        return new ResponseEntity((Object)this.doSave(avatar), HttpStatus.CREATED);
    }

    @Value(value="${avatar.max.size}")
    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    private AvatarLocation doSave(AvatarForm avatar) {
        if (avatar.getSize() > this.maxSize) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("stash.service.avatar.store.oversized", new Object[]{NumberUtils.formatSize((double)avatar.getSize()), NumberUtils.formatSize((double)this.maxSize)}));
        }
        String id = this.avatarService.saveTemporary(avatar.toSupplier());
        return new AvatarLocation(id, this.navBuilder.tmp().avatar(id).buildRelative());
    }
}

