/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.auth;

import com.atlassian.stash.internal.web.auth.BeforeLoginPluginAuthenticationFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class BeforeLoginPluginAuthenticationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(BeforeLoginPluginAuthenticationFilter.class);
    private static final String BEFORE_LOGIN_APPLIED = "com.atlassian.stash.before.login.filter.applied";
    private final ThreadLocal<Authentication> pluginProvidedAuthentication = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean filterApplied = request.getAttribute(BEFORE_LOGIN_APPLIED) != null;
        request.setAttribute(BEFORE_LOGIN_APPLIED, (Object)Boolean.TRUE);
        if (!filterApplied) {
            this.doBeforeBeforeLoginFilters(request, response, chain);
        } else {
            this.doInsideSpringSecurityChain(request, response, chain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBeforeBeforeLoginFilters(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecurityContext originalContext = SecurityContextHolder.getContext();
        SecurityContextHolder.setContext((SecurityContext)new DelegatingSecurityContext(this, originalContext != null ? originalContext : SecurityContextHolder.createEmptyContext(), null));
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.pluginProvidedAuthentication.remove();
            SecurityContextHolder.setContext((SecurityContext)originalContext);
        }
    }

    private void doInsideSpringSecurityChain(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean loginFromBeforeLoginPlugin;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean bl = loginFromBeforeLoginPlugin = this.pluginProvidedAuthentication.get() != null && (authentication == null || !authentication.isAuthenticated());
        if (loginFromBeforeLoginPlugin) {
            log.debug("Restoring authentication token for {} that was provided by a before-login plugin", (Object)((Authentication)this.pluginProvidedAuthentication.get()).getName());
            SecurityContextHolder.getContext().setAuthentication((Authentication)this.pluginProvidedAuthentication.get());
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    static /* synthetic */ ThreadLocal access$100(BeforeLoginPluginAuthenticationFilter x0) {
        return x0.pluginProvidedAuthentication;
    }
}

