/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.internal.user.CaptchaService;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.user.DetailedUser;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserAdminService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/admin/users/view"})
public class UserEditController {
    private static final String USER_EDIT_VIEW = "stash.admin.users.edit";
    private final StashAuthenticationContext authenticationContext;
    private final PermissionService permissionService;
    private final UserAdminService userAdminService;
    private final CaptchaService captchaService;

    @Autowired
    public UserEditController(StashAuthenticationContext authenticationContext, PermissionService permissionService, UserAdminService userAdminService, CaptchaService captchaService) {
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.userAdminService = userAdminService;
        this.captchaService = captchaService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showForm(@RequestParam String name) {
        DetailedUser user = this.userAdminService.getUserDetails(name);
        Permission highestGlobalPermission = this.getHighestGlobalPermission((StashUser)user);
        boolean forbidden = this.isForbiddenUpdate((StashUser)user);
        boolean editableDetails = !forbidden && user != null && user.isMutableDetails();
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(USER_EDIT_VIEW).put("username", (Object)name)).put("user", (Object)user)).put("captchaChallenged", (Object)this.captchaService.isCaptchaChallenged(name))).put("highestGlobalPermission", (Object)highestGlobalPermission)).put("editableDirectory", (Object)(user != null && user.isMutableDetails() ? 1 : 0))).put("editableDetails", (Object)editableDetails)).put("editablePermissions", (Object)(!forbidden ? 1 : 0))).put("editableGroups", (Object)(user != null && user.isMutableGroups() ? 1 : 0))).put("isDeletable", (Object)(editableDetails && !this.isCurrentUser((StashUser)user) ? 1 : 0))).build();
    }

    private Permission getHighestGlobalPermission(StashUser user) {
        return user == null ? null : this.permissionService.getHighestGlobalPermission(user.getName());
    }

    private boolean isCurrentUser(StashUser user) {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        return user.equals(currentUser);
    }

    private boolean isForbiddenUpdate(StashUser user) {
        return user != null && !this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN) && this.permissionService.hasGlobalPermission(user.getName(), Permission.SYS_ADMIN);
    }
}

