/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.internal.plugin.PluginValidationErrors;
import com.atlassian.stash.internal.web.admin.ServerSettingsController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.ui.PluginFormFragments;
import com.atlassian.stash.ui.PluginFormFragmentsFactory;
import com.atlassian.stash.ui.ValidationErrors;
import com.atlassian.stash.util.UrlUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/admin/server-settings"})
public class ServerSettingsController {
    public static final String FRAGS_SERVER_SETTINGS = "stash.admin.serversettings";
    public static final String PAGE_SERVER_SETTINGS = "stash.admin.serversettings";
    private final PluginFormFragmentsFactory fragmentsFactory;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public ServerSettingsController(PluginFormFragmentsFactory fragmentsFactory, ApplicationPropertiesService propertiesService) {
        this.fragmentsFactory = fragmentsFactory;
        this.propertiesService = propertiesService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showSettings() {
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.admin.serversettings").put("settings", (Object)this.loadServerSettings())).put("pluginFieldsContent", (Object)this.fragmentsFactory.forKey("stash.admin.serversettings", (Map)Maps.newHashMap()).getViewHtml())).build();
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView updateSettings(@Valid ServerSettings settings, Errors errors, HttpServletRequest request, RedirectAttributes redirectAttributes) {
        PluginValidationErrors pluginErrors = new PluginValidationErrors(errors);
        PluginFormFragments fragments = this.fragmentsFactory.forKey("stash.admin.serversettings", (Map)Maps.newHashMap());
        fragments.validate(request.getParameterMap(), (ValidationErrors)pluginErrors);
        if (pluginErrors.hasErrors()) {
            return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder("stash.admin.serversettings").put("settings", (Object)settings)).put("pluginFieldsContent", (Object)fragments.getErrorHtml(request.getParameterMap(), pluginErrors.getFieldErrors()))).putValidationErrors(errors).build();
        }
        this.updateServerSettings(settings);
        fragments.execute(request.getParameterMap());
        redirectAttributes.addFlashAttribute("saved", (Object)true);
        return new StashSoyResponseBuilder("redirect:/admin/server-settings").build();
    }

    private ServerSettings loadServerSettings() {
        ServerSettings settings = new ServerSettings();
        ServerSettings.access$002((ServerSettings)settings, (String)this.propertiesService.getDisplayName());
        ServerSettings.access$102((ServerSettings)settings, (String)this.propertiesService.getBaseUrl().toString());
        return settings;
    }

    private void updateServerSettings(ServerSettings settings) {
        this.propertiesService.setDisplayName(settings.getAppTitle());
        this.propertiesService.setBaseURL(UrlUtils.uncheckedCreateURI((String)settings.getBaseUrl()));
    }
}

