/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.web.admin.BasePermissionController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.PermissionValidationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/projects/{projectKey}/repos/{repoSlug}/permissions"})
public class RepositoryPermissionsController
extends BasePermissionController {
    public static final String REPOSITORY_EDIT_PERMISSIONS = "stash.repository.repositoryPermissions";
    private final RepositoryService repositoryService;
    private final ProjectService projectService;
    private final PermissionValidationService permissionValidationService;
    private final PermissionService permissionService;
    private final NavBuilder navBuilder;

    @Autowired
    public RepositoryPermissionsController(PermissionAdminService permissionAdminService, I18nService i18nService, RepositoryService repositoryService, ProjectService projectService, PermissionValidationService permissionValidationService, PermissionService permissionService, NavBuilder navBuilder) {
        super(permissionAdminService, i18nService);
        this.repositoryService = repositoryService;
        this.projectService = projectService;
        this.permissionValidationService = permissionValidationService;
        this.permissionService = permissionService;
        this.navBuilder = navBuilder;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView editRepositoryPermissions(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="repoSlug") String repoSlug) {
        Repository repository = this.repositoryService.getBySlug(projectKey, repoSlug);
        if (repository == null) {
            Project project = this.projectService.getByKey(projectKey);
            if (project == null) {
                throw this.newNoSuchProjectException(projectKey);
            }
            throw this.newNoSuchRepositoryException(project, repoSlug);
        }
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(REPOSITORY_EDIT_PERMISSIONS).put("repository", (Object)repository)).put("projectPermissionUrl", (Object)this.getProjectPermissionUrlIfAdmin(repository.getProject()))).put("permissionDataList", (Object)this.getPermissionData(new Permission[]{Permission.REPO_ADMIN, Permission.REPO_WRITE, Permission.REPO_READ}))).build();
    }

    private String getProjectPermissionUrlIfAdmin(Project project) {
        if (this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
            return this.navBuilder.project(project).permissions().buildRelative();
        }
        return null;
    }
}

