/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.web.admin.BasePermissionController;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectService;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/projects/{projectKey}/permissions"})
public class ProjectPermissionsController
extends BasePermissionController {
    public static final String PROJECT_EDIT_PERMISSIONS = "stash.project.projectPermissions";
    private final ProjectService projectService;

    @Autowired
    public ProjectPermissionsController(PermissionAdminService permissionAdminService, I18nService i18nService, ProjectService projectService) {
        super(permissionAdminService, i18nService);
        this.projectService = projectService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView editProjectPermissions(@PathVariable(value="projectKey") String projectKey) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            throw this.newNoSuchProjectException(projectKey);
        }
        if (project.getType() == ProjectType.PERSONAL) {
            throw new AccessDeniedException(this.i18nService.getMessage("stash.web.project.personal.permissions.not.modifiable", new Object[0]));
        }
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(PROJECT_EDIT_PERMISSIONS).put("project", (Object)project)).put("allRead", (Object)(this.permissionAdminService.hasAllProjectPermission(Permission.PROJECT_READ, project) || this.permissionAdminService.hasAllProjectPermission(Permission.PROJECT_WRITE, project) ? 1 : 0))).put("allWrite", (Object)this.permissionAdminService.hasAllProjectPermission(Permission.PROJECT_WRITE, project))).put("permissionDataList", (Object)this.getPermissionData(new Permission[]{Permission.PROJECT_ADMIN, Permission.PROJECT_WRITE, Permission.PROJECT_READ}))).build();
    }
}

