/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.stash.validation.OptionalString;
import com.atlassian.stash.validation.RequiredString;
import com.atlassian.stash.validation.groups.Create;
import com.atlassian.stash.validation.groups.Update;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.StringUtils;

public class ProjectForm {
    private String avatar;
    private String description;
    private String key;
    private String name;

    public String getAvatar() {
        return StringUtils.trimToNull((String)this.avatar);
    }

    @OptionalString(size=255)
    public String getDescription() {
        return this.description;
    }

    @Pattern(regexp="[a-zA-Z][a-zA-Z0-9_\\-]*", groups={Create.class, Update.class}, message="{com.atlassian.stash.validation.project.key.pattern.message}")
    @RequiredString(size=128)
    public String getKey() {
        return this.key;
    }

    @RequiredString(size=128)
    public String getName() {
        return this.name;
    }

    public boolean hasAvatar() {
        return StringUtils.isNotBlank((String)this.avatar);
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setDescription(String description) {
        this.description = StringUtils.trimToNull((String)description);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }
}

