/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.admin;

import com.atlassian.extras.api.stash.StashLicense;
import com.atlassian.stash.exception.LicenseException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.web.setup.LicenseForm;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/admin/license"})
public class LicenseController {
    public static final String VIEW = "stash.admin.license";
    public static final String EDIT_VIEW = "stash.admin.licenseedit";
    private final LicenseService licenseService;
    private final ApplicationPropertiesService propertiesService;
    private final I18nService i18nService;
    private final PermissionService permissionService;

    @Autowired
    public LicenseController(LicenseService licenseService, ApplicationPropertiesService propertiesService, I18nService i18nService, PermissionService permissionService) {
        this.licenseService = licenseService;
        this.propertiesService = propertiesService;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showLicense() {
        StashLicense license = this.licenseService.get();
        KeyedMessage overLimitMessage = this.licenseService.getOverLimitMessage();
        return ((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(VIEW).put("serverId", (Object)this.propertiesService.getServerId())).put("license", (Object)license)).put("canEdit", (Object)this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN))).put("usersRemainingMessage", (Object)this.formatUsersRemainingMessage(license))).put("overLimitMessage", (Object)(overLimitMessage == null ? null : overLimitMessage.getLocalisedMessage()))).build();
    }

    @RequestMapping(method={RequestMethod.GET}, params={"edit"})
    public ModelAndView showEditLicense() {
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("stash.web.license.sysadminonly", new Object[0]));
        }
        return this.createEditLicenseBuilder(new LicenseForm()).build();
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView editLicense(@Valid LicenseForm form, Errors errors, RedirectAttributes redirectAttributes) {
        if (!this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
            throw new AccessDeniedException(this.i18nService.getMessage("stash.web.license.sysadminonly", new Object[0]));
        }
        if (errors.hasErrors()) {
            return this.createEditLicenseBuilder(form).putValidationErrors(errors).build();
        }
        try {
            this.licenseService.update(form.getLicense());
        }
        catch (LicenseException e) {
            Map<String, List<String>> fieldErrors = Collections.singletonMap("license", Collections.singletonList(e.getLocalizedMessage()));
            return ((StashSoyResponseBuilder)this.createEditLicenseBuilder(form).putFieldErrors(fieldErrors)).build();
        }
        catch (ServiceException e) {
            return ((StashSoyResponseBuilder)this.createEditLicenseBuilder(form).putFormErrors(new String[]{e.getLocalizedMessage()})).build();
        }
        redirectAttributes.addFlashAttribute("saved", (Object)true);
        return new ModelAndView("redirect:/admin/license");
    }

    private StashSoyResponseBuilder createEditLicenseBuilder(LicenseForm form) {
        return (StashSoyResponseBuilder)((StashSoyResponseBuilder)new StashSoyResponseBuilder(EDIT_VIEW).put("serverId", (Object)this.propertiesService.getServerId())).put("form", (Object)form);
    }

    private String formatUsersRemainingMessage(StashLicense license) {
        if (license == null) {
            return this.formatUsersRemainingMessageFor(0);
        }
        if (license.isUnlimitedNumberOfUsers()) {
            return null;
        }
        int licensedUsers = this.licenseService.getLicensedUsersCount();
        int usersRemaining = license.getMaximumNumberOfUsers() - licensedUsers;
        if (usersRemaining < 0) {
            return null;
        }
        return this.formatUsersRemainingMessageFor(usersRemaining);
    }

    private String formatUsersRemainingMessageFor(int count) {
        return this.i18nService.getMessage("stash.web.license.users.remaining", new Object[]{count});
    }
}

