/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.stash.util.DateFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class StashDateFormatWebResourceTransformer
implements WebResourceTransformer {
    private static final Pattern PATTERN = Pattern.compile("date_format\\(\\s*(['\"])([\\w.-]+)\\1\\s*\\)");
    private final DateFormatter dateFormatter;

    public StashDateFormatWebResourceTransformer(DateFormatter dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public DownloadableResource transform(Element configElement, ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String transform(CharSequence originalContent) {
        Matcher matcher = PATTERN.matcher(originalContent);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String formatString = this.dateFormatter.getFormatString(matcher.group(2));
            matcher.appendReplacement(result, "");
            result.append("'").append(StringEscapeUtils.escapeJavaScript((String)StringUtils.defaultString((String)formatString))).append("'");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

