/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.FeatureDisabledException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.NoSuchProjectException;
import com.atlassian.stash.exception.NoSuchRepositoryException;
import com.atlassian.stash.exception.ResourceBusyException;
import com.atlassian.stash.exception.ScmClientException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

@Component(value="handlerExceptionResolver")
public class HandlerExceptionResolverImpl
implements AccessDeniedHandler,
HandlerExceptionResolver {
    private static final String VIEW_PREFIX = "stash.errors.";
    private static final Logger log = LoggerFactory.getLogger(HandlerExceptionResolverImpl.class);
    private final ViewResolver viewResolver;
    private final I18nService i18nService;
    private final StashAuthenticationContext authenticationContext;

    @Autowired
    public HandlerExceptionResolverImpl(ViewResolver viewResolver, I18nService i18nService, StashAuthenticationContext authenticationContext) {
        this.viewResolver = viewResolver;
        this.i18nService = i18nService;
        this.authenticationContext = authenticationContext;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        ModelAndView modelAndView = this.resolveException(response, (Exception)accessDeniedException);
        try {
            View view = this.viewResolver.resolveViewName(modelAndView.getViewName(), Locale.US);
            view.render(modelAndView.getModel(), request, response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (!this.authenticationContext.isAuthenticated()) {
            if (ex instanceof AuthorisationException || ex instanceof AccessDeniedException) {
                return null;
            }
            if (ex instanceof NoSuchEntityException) {
                throw new AccessDeniedException(ex.getMessage());
            }
        }
        return this.resolveException(response, ex);
    }

    @VisibleForTesting
    ModelAndView resolveException(HttpServletResponse response, Exception ex) {
        String template = this.templateForException(ex);
        HashMap<String, Exception> context = new HashMap<String, Exception>();
        context.put("error", ex);
        this.setStatusForException(ex, response);
        this.setTemplateContext(ex, context);
        return new ModelAndView(template, context);
    }

    private void setTemplateContext(Exception ex, Map<String, Object> context) {
        if (ex instanceof NoSuchRepositoryException) {
            context.put("project", ((NoSuchRepositoryException)ex).getProject());
        } else if (ex instanceof AuthorisationException) {
            context.put("errorHeadingOverride", this.i18nService.getMessage("stash.web.authorisationdenied.heading", new Object[0]));
        }
    }

    private void setStatusForException(Exception ex, HttpServletResponse response) {
        if (ex instanceof AccessDeniedException || ex instanceof AuthorisationException) {
            response.setStatus(401);
        } else if (ex instanceof FeatureDisabledException) {
            response.setStatus(400);
        } else if (ex instanceof IntegrityException) {
            response.setStatus(409);
        } else if (ex instanceof NoSuchEntityException) {
            response.setStatus(404);
        } else if (ex instanceof ResourceBusyException) {
            response.setStatus(503);
        } else {
            response.setStatus(500);
            if (ex instanceof ScmClientException) {
                log.error(ex.getMessage());
            } else {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private String templateForException(Exception ex) {
        String suffix = ex instanceof AccessDeniedException || ex instanceof AuthorisationException ? "error401" : (ex instanceof NoSuchRepositoryException ? "repo404" : (ex instanceof NoSuchProjectException ? "project404" : (ex instanceof NoSuchEntityException ? "error404" : (ex instanceof ResourceBusyException ? "error503" : "error500"))));
        return VIEW_PREFIX + suffix;
    }
}

