/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.stash.internal.web.auth.IgnoresXsrf;
import com.atlassian.stash.internal.web.soy.StashSoyResponseBuilder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ErrorPageController {
    public static final String ATTRIBUTE_EXCEPTION = "javax.servlet.error.exception";
    public static final String ATTRIBUTE_REQUEST_URI = "javax.servlet.error.request_uri";
    private static final Logger log = LoggerFactory.getLogger(ErrorPageController.class);

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @RequestMapping(value={"/error401"})
    @IgnoresXsrf
    public ModelAndView handle401(HttpServletRequest request) {
        Object requestUri = request.getAttribute(ATTRIBUTE_REQUEST_URI);
        log.debug("User is not authorized to access [{}]", requestUri);
        return this.createModelAndView(request, "stash.errors.error401");
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @RequestMapping(value={"/error404"})
    @IgnoresXsrf
    public ModelAndView handle404(HttpServletRequest request) {
        Object requestUri = request.getAttribute(ATTRIBUTE_REQUEST_URI);
        log.debug("Page not found attempting to access [{}]", requestUri);
        return this.createModelAndView(request, "stash.errors.error404");
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @RequestMapping(value={"/error500"})
    @IgnoresXsrf
    public ModelAndView handle500(HttpServletRequest request) {
        Object requestUri = request.getAttribute(ATTRIBUTE_REQUEST_URI);
        Object exception = request.getAttribute(ATTRIBUTE_EXCEPTION);
        if (exception instanceof Throwable) {
            log.error("There was an unhandled exception loading [" + requestUri + "]", (Throwable)exception);
        } else {
            log.error("There was an unhandled error loading [{}]", requestUri);
        }
        return new ModelAndView("stash.errors.error500");
    }

    private ModelAndView createModelAndView(HttpServletRequest request, String template) {
        StashSoyResponseBuilder responseBuilder = new StashSoyResponseBuilder(template);
        Object error = request.getAttribute("javax.servlet.error.message");
        if (error instanceof String) {
            responseBuilder.put("errorHeadingOverride", error);
        }
        return responseBuilder.build();
    }
}

