/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web;

import com.atlassian.stash.internal.server.InternalApplicationStatusService;
import com.atlassian.stash.server.ApplicationState;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ApplicationStatusServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ApplicationStatusServlet.class);
    private volatile InternalApplicationStatusService applicationStatusService;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationState state = this.getApplicationState(req);
        resp.setStatus(state == ApplicationState.ERROR ? 500 : 200);
        resp.setContentType("application/json");
        resp.getWriter().append("{\"state\":\"").append(state.name()).append("\"}");
    }

    private ApplicationState getApplicationState(HttpServletRequest request) {
        WebApplicationContext context;
        if (this.applicationStatusService == null && (context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext())) != null) {
            try {
                this.applicationStatusService = (InternalApplicationStatusService)context.getBean(InternalApplicationStatusService.class);
            }
            catch (BeansException e) {
                log.debug("Could not obtain ApplicationStatusService from Spring context ({})", (Object)e.getMessage());
            }
        }
        if (this.applicationStatusService != null) {
            return this.applicationStatusService.getState();
        }
        return ApplicationState.ERROR;
    }
}

