/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.stash.nav.NavBuilder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;

public class StashLoginUrlAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final Logger log = LoggerFactory.getLogger(StashLoginUrlAuthenticationEntryPoint.class);
    private final NavBuilder navBuilder;

    public StashLoginUrlAuthenticationEntryPoint(String loginUrl, NavBuilder navBuilder) {
        super(loginUrl);
        this.navBuilder = navBuilder;
    }

    protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        NavBuilder.Login loginBuilder = this.navBuilder.login();
        this.addNextParam(request, loginBuilder);
        String loginUrl = loginBuilder.buildRelNoContext();
        log.debug("Redirecting {} to {}", (Object)request.getRequestURI(), (Object)loginUrl);
        return loginUrl;
    }

    private void addNextParam(HttpServletRequest request, NavBuilder.Login loginBuilder) {
        if ("GET".equals(request.getMethod())) {
            loginBuilder.next();
        }
    }
}

