/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.auth.HttpAuthenticationHandler;
import com.atlassian.stash.auth.HttpAuthenticationHandlerModuleDescriptor;
import com.atlassian.stash.auth.HttpLogoutHandler;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class PluginLogoutHandler
implements LogoutHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginLogoutHandler.class);
    private static final Predicate<HttpAuthenticationHandler> IS_LOGOUT_HANDLER = new /* Unavailable Anonymous Inner Class!! */;
    private static final Function<HttpAuthenticationHandler, HttpLogoutHandler> TO_LOGOUT_HANDLER = new /* Unavailable Anonymous Inner Class!! */;
    private final PluginAccessor pluginAccessor;

    public PluginLogoutHandler(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        Object principal;
        response.setHeader("Cache-Control", "private, max-age=0, no-cache");
        response.setDateHeader("Expires", 0L);
        Object object = principal = authentication == null ? null : authentication.getPrincipal();
        if (principal instanceof StashUser) {
            StashUser user = (StashUser)principal;
            for (HttpLogoutHandler handler : this.getLogoutHandlers()) {
                try {
                    log.debug("logout - delegating to handler {}", (Object)handler.getClass().getName());
                    handler.logout(user, request, response);
                }
                catch (Exception e) {
                    log.warn(handler.getClass().getName() + " encountered an error while login out user " + user.getName(), (Throwable)e);
                }
            }
        }
    }

    private Iterable<HttpLogoutHandler> getLogoutHandlers() {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationHandlerModuleDescriptor.class);
        return Chainable.chain((Iterable)ModuleDescriptorUtils.toSortedModules((Iterable)descriptors)).filter(IS_LOGOUT_HANDLER).transform(TO_LOGOUT_HANDLER);
    }
}

