/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.Product;
import com.atlassian.stash.auth.HttpAuthenticationContext;
import com.atlassian.stash.auth.HttpAuthenticationHandler;
import com.atlassian.stash.auth.HttpAuthenticationHandlerModuleDescriptor;
import com.atlassian.stash.exception.NoSuchUserException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.Profiled;
import com.atlassian.stash.internal.auth.CaptchaResponse;
import com.atlassian.stash.internal.spring.security.HttpAuthenticationContextToken;
import com.atlassian.stash.internal.spring.security.PluginAuthenticationProvider;
import com.atlassian.stash.internal.user.CaptchaService;
import com.atlassian.stash.internal.user.CaptchaTicket;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.user.AuthenticationException;
import com.atlassian.stash.user.AuthenticationSystemException;
import com.atlassian.stash.user.CaptchaAuthenticationException;
import com.atlassian.stash.user.InactiveUserAuthenticationException;
import com.atlassian.stash.user.NoAccessAuthenticationException;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.atlassian.stash.util.UncheckedOperation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="authenticationProvider")
public class PluginAuthenticationProvider
implements AuthenticationProvider {
    private static final String CAPTCHA = "captcha";
    private static final Logger log = LoggerFactory.getLogger(PluginAuthenticationProvider.class);
    private final CaptchaService captchaService;
    private final I18nService i18nService;
    private final InternalPermissionService permissionService;
    private final PluginAccessor pluginAccessor;

    @Autowired
    public PluginAuthenticationProvider(CaptchaService captchaService, I18nService i18nService, InternalPermissionService permissionService, PluginAccessor pluginAccessor) {
        this.captchaService = captchaService;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.pluginAccessor = pluginAccessor;
    }

    @Profiled
    public Authentication authenticate(Authentication authentication) throws org.springframework.security.core.AuthenticationException {
        HttpAuthenticationContextToken authToken = (HttpAuthenticationContextToken)authentication;
        StashUser user = this.attemptAuthentication(authToken.getContext());
        if (user == null) {
            return null;
        }
        StashUserAuthenticationToken token = StashUserAuthenticationToken.forUser((StashUser)user);
        if (!this.permissionService.hasGlobalPermission(token, Permission.LICENSED_USER)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.web.auth.notlicensed", new Object[]{Product.NAME});
            throw new DisabledException(message.getRootMessage(), (Throwable)new NoAccessAuthenticationException(message));
        }
        return token;
    }

    public boolean supports(Class<?> aClass) {
        return HttpAuthenticationContextToken.class.isAssignableFrom(aClass);
    }

    private StashUser attemptAuthentication(HttpAuthenticationContext context) {
        CaptchaResponse captchaResponse = this.extractCaptchaResponse(context);
        StashUser user = null;
        CaptchaTicket captchaTicket = null;
        for (HttpAuthenticationHandlerModuleDescriptor moduleDescriptor : this.getSortedAuthenticationModuleDescriptors()) {
            try (Timer timer = TimerUtils.start((String)("attemptAuthentication - " + moduleDescriptor.getCompleteKey()));){
                HttpAuthenticationHandler authenticator = moduleDescriptor.getModule();
                log.debug("attempting authentication with authenticator {}", (Object)moduleDescriptor.getCompleteKey());
                1 authenticateOperation = new /* Unavailable Anonymous Inner Class!! */;
                try {
                    if (moduleDescriptor.isCaptchaSupported() && this.isCredentialsProvided(context)) {
                        if (captchaTicket == null) {
                            captchaTicket = this.captchaService.checkCaptcha(context.getUsername(), captchaResponse);
                        }
                        user = this.captchaService.authenticateWithCaptcha(captchaTicket, (UncheckedOperation)authenticateOperation);
                    } else {
                        user = (StashUser)authenticateOperation.perform();
                    }
                }
                catch (CaptchaAuthenticationException e) {
                    log.debug("Authentication for {} failed - CAPTCHA required", (Object)moduleDescriptor.getCompleteKey());
                    throw new LockedException(e.getLocalizedMessage(), (Throwable)e);
                }
                catch (AuthenticationSystemException e) {
                    log.warn("Could not authenticate " + context.getUsername() + "; authentication by " + moduleDescriptor.getCompleteKey() + " failed", (Throwable)e);
                    throw new AuthenticationServiceException(e.getLocalizedMessage(), (Throwable)e);
                }
                catch (InactiveUserAuthenticationException e) {
                    log.debug("Authentication for {} failed - User is inactive", (Object)moduleDescriptor.getCompleteKey());
                    throw new DisabledException(e.getLocalizedMessage(), (Throwable)e);
                }
                catch (AuthenticationException e) {
                    log.debug("Authentication for {} failed - Bad credentials", (Object)moduleDescriptor.getCompleteKey());
                    throw new BadCredentialsException(e.getLocalizedMessage(), (Throwable)e);
                }
                catch (NoSuchUserException e) {
                    log.debug("Authentication for {} failed - User not found", (Object)moduleDescriptor.getCompleteKey());
                    throw new BadCredentialsException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (user == null) continue;
            break;
        }
        return user;
    }

    private CaptchaResponse extractCaptchaResponse(HttpAuthenticationContext context) {
        String challengeId = context.getRequest().getRequestedSessionId();
        String userResponse = StringUtils.trimToNull((String)context.getRequest().getParameter(CAPTCHA));
        return StringUtils.isNotEmpty((String)challengeId) && userResponse != null ? new CaptchaResponse(challengeId, userResponse) : null;
    }

    private Iterable<HttpAuthenticationHandlerModuleDescriptor> getSortedAuthenticationModuleDescriptors() {
        ArrayList descriptors = Lists.newArrayList((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(HttpAuthenticationHandlerModuleDescriptor.class));
        Collections.sort(descriptors);
        return descriptors;
    }

    private boolean isCredentialsProvided(HttpAuthenticationContext context) {
        Object credentials = context.getCredentials();
        return StringUtils.isNotBlank((String)context.getUsername()) && credentials instanceof String && StringUtils.isNotEmpty((String)((String)credentials));
    }
}

