/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class MaintenanceRequestMatcher
implements RequestMatcher {
    private static final String PATH_MAINTENANCE_LOCK = "/maintenance/lock";

    public boolean matches(HttpServletRequest request) {
        return "/mvc".equals(request.getServletPath()) && (this.isMaintenance(request) || this.isUnlockMaintenance(request) || this.isViewLock(request));
    }

    private boolean isViewLock(HttpServletRequest request) {
        return request.getMethod().equals("GET") && request.getPathInfo().equals(PATH_MAINTENANCE_LOCK);
    }

    private boolean isMaintenance(HttpServletRequest request) {
        return request.getPathInfo().equals("/maintenance");
    }

    private boolean isUnlockMaintenance(HttpServletRequest request) {
        return request.getMethod().equals("DELETE") && request.getPathInfo().equals(PATH_MAINTENANCE_LOCK);
    }
}

