/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.security;

import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class HttpSessionSecurityContextRepository
implements SecurityContextRepository {
    public static final String STASH_SECURITY_CONTEXT_KEY = "STASH_SECURITY_CONTEXT";
    private final RequestMatcher canCreateHttpSessionMatcher;
    private final UserService userService;

    public HttpSessionSecurityContextRepository(RequestMatcher canCreateHttpSessionMatcher, UserService userService) {
        this.canCreateHttpSessionMatcher = canCreateHttpSessionMatcher;
        this.userService = userService;
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        boolean createNewSession;
        HttpSession httpSession;
        Authentication authentication = context.getAuthentication();
        if (authentication == null) {
            HttpSession httpSession2 = request.getSession(false);
            if (httpSession2 != null) {
                httpSession2.removeAttribute(STASH_SECURITY_CONTEXT_KEY);
            }
        } else if (authentication instanceof StashUserAuthenticationToken && (httpSession = request.getSession(createNewSession = this.canCreateHttpSessionMatcher.matches(request) && !response.isCommitted())) != null) {
            StashUser user = ((StashUserAuthenticationToken)authentication).getPrincipal();
            if (user == null) {
                httpSession.removeAttribute(STASH_SECURITY_CONTEXT_KEY);
            } else if (!ObjectUtils.equals((Object)httpSession.getAttribute(STASH_SECURITY_CONTEXT_KEY), (Object)user.getId())) {
                httpSession.setAttribute(STASH_SECURITY_CONTEXT_KEY, (Object)user.getId());
            }
        }
    }

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        StashUser user;
        SecurityContextImpl securityContext = new SecurityContextImpl();
        HttpServletRequest request = requestResponseHolder.getRequest();
        Integer authenticationId = this.getAuthenticationId(request);
        if (authenticationId != null && (user = this.userService.getUserById(authenticationId.intValue())) != null && user.isActive()) {
            securityContext.setAuthentication((Authentication)StashUserAuthenticationToken.forUser((StashUser)user));
        }
        return securityContext;
    }

    private Integer getAuthenticationId(HttpServletRequest request) {
        Object idFromSession;
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && (idFromSession = httpSession.getAttribute(STASH_SECURITY_CONTEXT_KEY)) instanceof Integer) {
            return (Integer)idFromSession;
        }
        return null;
    }

    public boolean containsContext(HttpServletRequest request) {
        return this.getAuthenticationId(request) != null;
    }
}

