/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import com.atlassian.johnson.context.JohnsonContextListener;
import com.atlassian.johnson.plugin.servlet.filter.JohnsonServletFilterModuleContainerFilter;
import com.atlassian.johnson.spring.lifecycle.LifecycleDelegatingFilterProxy;
import com.atlassian.johnson.spring.lifecycle.LifecycleDispatcherServlet;
import com.atlassian.johnson.spring.lifecycle.LifecycleHttpRequestHandlerServlet;
import com.atlassian.plugin.servlet.ServletModuleContainerServlet;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.stash.internal.johnson.JohnsonServlet;
import com.atlassian.stash.internal.johnson.filters.BypassableJohnson503Filter;
import com.atlassian.stash.internal.johnson.filters.BypassableJohnsonFilter;
import com.atlassian.stash.internal.lifecycle.DefaultStartupManager;
import com.atlassian.stash.internal.lifecycle.StartupManager;
import com.atlassian.stash.internal.lifecycle.StartupUtils;
import com.atlassian.stash.internal.logback.web.LogbackConfigListener;
import com.atlassian.stash.internal.web.ApplicationStatusServlet;
import com.atlassian.stash.internal.web.context.ContextCleanupListener;
import com.atlassian.stash.internal.web.filters.ForbiddenFilter;
import com.atlassian.stash.internal.web.filters.PathEncodingFilter;
import com.atlassian.stash.internal.web.startup.StartupServlet;
import com.google.common.collect.ImmutableMap;
import com.hazelcast.web.SessionListener;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpSession;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;

public class StashWebApplicationInitializer
implements WebApplicationInitializer {
    private static final EnumSet<DispatcherType> DEFAULT = EnumSet.noneOf(DispatcherType.class);
    private static final String URL_ALL = "/*";
    private static final String URL_DOWNLOAD = "/download/*";
    private static final String URL_GIT = "/git/*";
    private static final String URL_MVC = "/mvc/*";
    private static final String URL_PLUGIN_SERVLETS = "/plugins/servlet/*";
    private static final String URL_REST = "/rest/*";
    private static final String URL_SCM = "/scm/*";
    private static final String URL_STATUS = "/status";

    public void onStartup(ServletContext servletContext) throws ServletException {
        StartupUtils.setStartupManager((ServletContext)servletContext, (StartupManager)new DefaultStartupManager(servletContext));
        servletContext.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        this.addListeners(servletContext);
        this.addFilters(servletContext);
        this.addServlets(servletContext);
    }

    private void addFilters(ServletContext context) {
        FilterRegistration.Dynamic requestCharsetFilter = context.addFilter("DefaultCharsetRequestFilter", CharacterEncodingFilter.class);
        requestCharsetFilter.setInitParameter("encoding", "UTF-8");
        requestCharsetFilter.addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_ALL});
        FilterRegistration.Dynamic pathCharsetFilter = context.addFilter("DefaultRequestPathCharsetFilter", PathEncodingFilter.class);
        pathCharsetFilter.setInitParameter("encoding", "UTF-8");
        pathCharsetFilter.addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_SCM, URL_GIT});
        FilterRegistration.Dynamic hazelcastFilter = this.registerLifecycleFilter(context, "hazelcastFilter");
        hazelcastFilter.setInitParameters((Map)ImmutableMap.of((Object)"map-name", (Object)HttpSession.class.getName(), (Object)"targetFilterLifecycle", (Object)"true"));
        hazelcastFilter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR), true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "requestAttributeFilter").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        context.addFilter("johnson503", BypassableJohnson503Filter.class).addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_DOWNLOAD, URL_GIT, URL_PLUGIN_SERVLETS, URL_REST, URL_SCM});
        context.addFilter("johnson", BypassableJohnsonFilter.class).addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "pluginProvidedAuthenticationFilter").addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_ALL});
        this.registerModuleContainerFilters(context, FilterLocation.AFTER_ENCODING);
        this.registerModuleContainerFilters(context, FilterLocation.BEFORE_LOGIN);
        this.registerLifecycleFilter(context, "trustedApplicationsAuthenticationFilter").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        FilterRegistration.Dynamic urlRewriteFilter = context.addFilter("urlRewriteFilter", UrlRewriteFilter.class);
        urlRewriteFilter.setInitParameters((Map)ImmutableMap.of((Object)"confReloadCheckInterval", (Object)"-1", (Object)"statusEnabled", (Object)"false"));
        urlRewriteFilter.addMappingForUrlPatterns(DEFAULT, true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "springSecurityFilterChain").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        this.registerLifecycleFilter(context, "authenticationAttributeFilter").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        this.registerModuleContainerFilters(context, FilterLocation.BEFORE_DECORATION);
        FilterRegistration.Dynamic sitemesh = this.registerLifecycleFilter(context, "sitemesh");
        sitemesh.setInitParameter("targetFilterLifecycle", "true");
        sitemesh.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), true, new String[]{URL_PLUGIN_SERVLETS});
        this.registerModuleContainerFilters(context, FilterLocation.BEFORE_DISPATCH);
        this.registerLifecycleFilter(context, "standardResponseHeadersFilter").addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD), true, new String[]{URL_ALL});
        context.addFilter("forbidden-web-inf", ForbiddenFilter.class).addMappingForUrlPatterns(EnumSet.of(DispatcherType.FORWARD), true, new String[]{"/WEB-INF/*"});
    }

    private void addListeners(ServletContext context) {
        context.addListener(LogbackConfigListener.class);
        JohnsonContextListener.register((ServletContext)context);
        context.addListener(ContextCleanupListener.class);
        context.addListener(RequestContextListener.class);
        context.addListener(SessionListener.class);
    }

    private void addServlets(ServletContext context) {
        context.addServlet("plugins", ServletModuleContainerServlet.class).addMapping(new String[]{URL_PLUGIN_SERVLETS});
        this.registerLifecycleServlet(context, "scmServlet").addMapping(new String[]{URL_SCM, URL_GIT});
        this.registerLifecycleServlet(context, "fileServerServlet").addMapping(new String[]{URL_DOWNLOAD});
        this.registerLifecycleServlet(context, "streamsEmptyActivityServlet").addMapping(new String[]{"/plugins/servlet/streams", "/rest/activity-stream/1.0/config"});
        context.addServlet("statusServlet", ApplicationStatusServlet.class).addMapping(new String[]{URL_STATUS});
        context.addServlet("johnsonServlet", JohnsonServlet.class).addMapping(new String[]{"/unavailable"});
        context.addServlet("startupServlet", StartupServlet.class).addMapping(new String[]{"/system/startup"});
        ServletRegistration.Dynamic springMvc = context.addServlet("springMvc", LifecycleDispatcherServlet.class);
        springMvc.setAsyncSupported(true);
        springMvc.setInitParameters((Map)ImmutableMap.of((Object)"contextConfigLocation", (Object)"classpath:stash-context.xml, classpath:stash-mvc.xml", (Object)"contextInitializerClasses", (Object)"com.atlassian.stash.internal.spring.LifecycleApplicationContextInitializer", (Object)"exceptionTranslatorClass", (Object)"com.atlassian.stash.internal.johnson.StashEventExceptionTranslator"));
        springMvc.setLoadOnStartup(2);
        springMvc.addMapping(new String[]{URL_MVC});
    }

    private FilterRegistration.Dynamic registerLifecycleFilter(ServletContext context, String name) {
        return context.addFilter(name, LifecycleDelegatingFilterProxy.class);
    }

    private ServletRegistration.Dynamic registerLifecycleServlet(ServletContext context, String name) {
        ServletRegistration.Dynamic servlet = context.addServlet(name, LifecycleHttpRequestHandlerServlet.class);
        servlet.setLoadOnStartup(1);
        return servlet;
    }

    private void registerModuleContainerFilters(ServletContext context, FilterLocation location) {
        this.registerModuleContainerFilter(context, location, DispatcherType.REQUEST);
        this.registerModuleContainerFilter(context, location, DispatcherType.FORWARD);
        this.registerModuleContainerFilter(context, location, DispatcherType.INCLUDE);
        this.registerModuleContainerFilter(context, location, DispatcherType.ERROR);
    }

    private FilterRegistration.Dynamic registerModuleContainerFilter(ServletContext context, FilterLocation location, DispatcherType dispatcher) {
        String name = ("filter-plugin-dispatcher-" + location + "-" + dispatcher).replace("_", "-").toLowerCase(Locale.US);
        FilterRegistration.Dynamic filter = context.addFilter(name, JohnsonServletFilterModuleContainerFilter.class);
        filter.setInitParameters((Map)ImmutableMap.of((Object)"location", (Object)location.name(), (Object)"dispatcher", (Object)dispatcher.name()));
        filter.addMappingForUrlPatterns(EnumSet.of(dispatcher), true, new String[]{URL_ALL});
        return filter;
    }
}

