/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.protocol.http;

import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.Scm;
import com.atlassian.stash.scm.ScmProtocol;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HttpScmProtocol
implements ScmProtocol {
    public static final String GIT = "git";
    public static final String HTTP = "http";
    private final NavBuilder navBuilder;

    public HttpScmProtocol(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
    }

    @Nonnull
    public String getName() {
        return HTTP;
    }

    public boolean supports(@Nonnull Scm scm) {
        Preconditions.checkNotNull((Object)"scm", (Object)scm);
        return GIT.equals(scm.getId());
    }

    @Nonnull
    public String getCloneUrl(@Nonnull Repository repository, @Nullable StashUser user) {
        Preconditions.checkNotNull((Object)"repository", (Object)repository);
        Preconditions.checkArgument((boolean)GIT.equals(repository.getScmId()), (Object)String.format("SCM repositories of type %s are not supported by protocol %s", repository.getScmId(), this.getName()));
        return this.navBuilder.repo(repository).clone(GIT).buildAbsoluteWithUsernameFor(user);
    }
}

