/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.http.mime.BrowserUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.sal.api.web.context.HttpContext;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="resourceBatchingConfiguration")
@AvailableToPlugins(value=ResourceBatchingConfiguration.class)
public class StashResourceBatchingConfiguration
extends DefaultResourceBatchingConfiguration {
    private static final String AUI_PLUGIN_KEY = "com.atlassian.auiplugin";
    private static final String AJS_MODULE_KEY = "com.atlassian.auiplugin:ajs";
    private static final String PAGE_LAYOUT_MODULE_KEY = "com.atlassian.auiplugin:aui-experimental-page-layout";
    private static final String STASH_WEB_PLUGIN_KEY = "com.atlassian.stash.stash-web-plugin";
    private static final String WEBRESOURCE_DATA_MODULE_KEY = "com.atlassian.plugins.atlassian-plugins-webresource-plugin:data";
    private static final String STASH_GLOBAL_MODULE_KEY = "com.atlassian.stash.stash-web-plugin:global";
    private static final List<String> SUPER_BATCH_MODULES = ImmutableList.builder().add((Object)"com.atlassian.auiplugin:ajs").add((Object)"com.atlassian.auiplugin:aui-experimental-page-layout").add((Object)"com.atlassian.plugins.atlassian-plugins-webresource-plugin:data").add((Object)"com.atlassian.stash.stash-web-plugin:global").build();
    private final HttpContext httpContext;

    @Autowired
    public StashResourceBatchingConfiguration(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public List<String> getSuperBatchModuleCompleteKeys() {
        return SUPER_BATCH_MODULES;
    }

    public boolean isSuperBatchingEnabled() {
        return this.shouldBatch();
    }

    public boolean isContextBatchingEnabled() {
        return this.shouldBatch();
    }

    public boolean isPluginWebResourceBatchingEnabled() {
        return this.shouldBatch();
    }

    private boolean shouldBatch() {
        return !Boolean.getBoolean("atlassian.dev.mode") || this.userAgentRequiresBatching();
    }

    private boolean userAgentRequiresBatching() {
        HttpServletRequest request = this.httpContext.getRequest();
        return request != null && BrowserUtils.isIE((String)request.getHeader("user-agent"));
    }
}

