/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.nav;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.request.RequestEndedEvent;
import com.atlassian.stash.event.request.RequestStartedEvent;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.nav.NavBuilderImpl;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=NavBuilder.class)
@Component(value="navBuilder")
public class NavBuilderImpl
implements NavBuilder,
StatefulService {
    private static final Function<String, String> ENCODE_PATH = new /* Unavailable Anonymous Inner Class!! */;
    private static final Function<String, String> ENCODE_PATH_FOR_SHELL = new /* Unavailable Anonymous Inner Class!! */;
    private static final String ABOUT = "about";
    private static final String ADMIN = "admin";
    private static final String API = "api";
    private static final String APPLICATION_LINKS = "applinks";
    private static final String AT = "at";
    private static final String ATTACHMENTS = "attachments";
    private static final String AUTHENTICATION = "authentication";
    private static final String AVATARS = "avatars";
    private static final String AVATAR = "avatar";
    private static final String AVATAR_EXTENSION = ".png";
    private static final String BRANCHES = "branches";
    private static final String BROWSE = "browse";
    private static final String CAPTCHA = "captcha";
    private static final String CLUSTERING = "clustering";
    private static final String COMMENT_ID = "commentId";
    private static final String COMMITS = "commits";
    private static final String COMPARE = "compare";
    private static final String CREATE = "create";
    private static final String DB = "db";
    private static final String DELETE = "delete";
    private static final String DIFF = "diff";
    private static final String DIRECTION = "direction";
    private static final String DO_LOGOUT = "j_stash_security_logout";
    private static final String EDIT = "edit";
    private static final String FORK = "fork";
    private static final String GROUPS = "groups";
    private static final String HOOKS = "hooks";
    private static final String I18N = "i18n";
    private static final String LICENSE = "license";
    private static final String LIMIT = "limit";
    private static final String LIST_APPLICATION_LINKS = "listApplicationLinks";
    private static final String LOGIN = "login";
    private static final String LOGGING = "logging";
    private static final String MAIL_SERVER = "mail-server";
    private static final String MVC = "mvc";
    private static final String OAUTH = "oauth";
    private static final String OVERVIEW = "overview";
    private static final String PASSWORDRESET = "passwordreset";
    private static final String PERMISSIONS = "permissions";
    private static final String PLUGINS = "plugins";
    private static final String PROFILE = "profile";
    private static final String PROJECTS = "projects";
    private static final String PULL_REQUESTS = "pull-requests";
    private static final String REPOS = "repos";
    private static final String REST = "rest";
    private static final String RETRIEVE_PASSWORD = "retrievePassword";
    private static final String SCM = "scm";
    private static final String SECURITY = "security";
    private static final String SERVER_SETTINGS = "server-settings";
    private static final String SERVLET = "servlet";
    private static final String SETTINGS = "settings";
    private static final String SETUP = "setup";
    private static final String SIGNUP = "signup";
    private static final String SECURITY_CHECK = "j_stash_security_check";
    private static final String SSH_SECTION_HASH = "ssh";
    private static final String START = "start";
    private static final String STATE = "state";
    private static final String SYSTEM_INFO = "system-info";
    private static final String TAGS = "tags";
    private static final String TMP = "tmp";
    private static final String TOKENS = "access-tokens";
    private static final String UNWATCH = "unwatch";
    private static final String UPM = "upm";
    private static final String USERS = "users";
    private static final String VIEW = "view";
    private static final String XSRF_NOTIFICATION = "xsrfNotification";
    private static final String GETTING_STARTED = "getting-started";
    private static final String ACCOUNT = "account";
    private static final String PASSWORD = "password";
    private static final Logger log = LoggerFactory.getLogger(NavBuilderImpl.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final ThreadLocal<RequestConfiguration> requestConfiguration;
    private final StashAuthenticationContext stashAuthenticationContext;

    @Autowired
    public NavBuilderImpl(ApplicationPropertiesService applicationPropertiesService, StashAuthenticationContext stashAuthenticationContext) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.requestConfiguration = new ThreadLocal();
        this.stashAuthenticationContext = stashAuthenticationContext;
    }

    @EventListener
    public void onRequestStarted(RequestStartedEvent event) {
        if (event.isHttp()) {
            URI uri;
            HttpServletRequest request = (HttpServletRequest)event.getRequestContext().getRawRequest();
            try {
                int port = request.getServerPort();
                if ("http".equals(request.getScheme()) && port == 80 || "https".equals(request.getScheme()) && port == 443) {
                    port = -1;
                }
                uri = new URI(request.getScheme(), null, request.getServerName(), port, request.getContextPath(), null, null);
            }
            catch (URISyntaxException e) {
                log.error("Failed to construct a URI for the NavBuilder from the current requests. Defaulting to application properties.", (Throwable)e);
                uri = this.getBaseUrl();
            }
            String requestUrl = request.getRequestURI();
            String queryString = request.getQueryString();
            this.requestConfiguration.set(new RequestConfiguration(uri, "true".equals(request.getParameter("useBaseUrlToken")), requestUrl, queryString));
        }
    }

    @EventListener
    public void onRequestEnded(RequestEndedEvent ignored) {
        this.requestConfiguration.remove();
    }

    private URI buildBaseUri() {
        RequestConfiguration config = (RequestConfiguration)this.requestConfiguration.get();
        return config != null ? config.getRequestBaseUri() : this.getBaseUrl();
    }

    public String buildBaseUrl() {
        return this.buildBaseUri().toASCIIString();
    }

    protected String buildAbsoluteUrl(URI defaultBaseUrl) {
        RequestConfiguration config = (RequestConfiguration)this.requestConfiguration.get();
        if (config != null && config.isBaseUriTokenRequested()) {
            return "$$$$stash.baseUrl%$$$$";
        }
        if (defaultBaseUrl == null) {
            return null;
        }
        return defaultBaseUrl.toASCIIString();
    }

    public String buildAbsolute() {
        return this.buildAbsoluteUrl(this.buildBaseUri());
    }

    public String buildConfigured() {
        URI baseUrl = this.getBaseUrl();
        return this.buildAbsoluteUrl(baseUrl != null ? baseUrl : this.buildBaseUri());
    }

    public String buildRelative() {
        return this.buildBaseUri().getRawPath();
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.Project project(@Nonnull String key) {
        return new ProjectImpl(this, key);
    }

    public NavBuilder.Project project(@Nonnull Project project) {
        return new ProjectImpl(this, project.getKey());
    }

    public NavBuilder.Repo repo(@Nonnull Repository repository) {
        return new RepoImpl(this, repository.getProject().getKey(), repository.getSlug());
    }

    public NavBuilder.Login login() {
        RequestConfiguration config = (RequestConfiguration)this.requestConfiguration.get();
        return new LoginImpl(this, config);
    }

    public NavBuilder.Builder<?> logout() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.Builder<?> signup() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.Builder<?> captcha() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.Builder<?> retrievePassword() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.Builder<?> passwordReset() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.Profile profile() {
        return new CurrentUserProfileImpl(this);
    }

    public NavBuilder.Profile userBySlug(String slug) {
        return new UserProfileImpl(this, slug);
    }

    public NavBuilder.Profile user(StashUser user) {
        return new UserProfileImpl(this, user.getSlug());
    }

    public NavBuilder.Builder<?> securityCheck() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.Builder<?> xsrfNotification() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.ListProjects allProjects() {
        return new ListProjectsImpl(this);
    }

    public NavBuilder.GlobalListRepos allRepos() {
        return new GlobalListReposImpl(this);
    }

    public NavBuilder.CreateProject createProject() {
        return new CreateProjectImpl(this);
    }

    public NavBuilder.UserAccount account() {
        return new UserAccountImpl(this);
    }

    public NavBuilder.Admin admin() {
        return new AdminImpl(this);
    }

    public NavBuilder.Builder<?> about() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.PluginServlets pluginServlets() {
        return new PluginServletsImpl(this);
    }

    public NavBuilder.Rest rest() {
        return new RestImpl(this);
    }

    public NavBuilder.Builder<?> setup() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public NavBuilder.Builder<?> welcome() {
        return this.gettingStarted();
    }

    public NavBuilder.Tmp tmp() {
        return new TmpImpl(this, null);
    }

    @Nonnull
    public NavBuilder.Addons addons() {
        return new AddonsImpl(this, null);
    }

    public NavBuilder.GettingStarted gettingStarted() {
        return new GettingStartedImpl(this, (RequestConfiguration)this.requestConfiguration.get());
    }

    private List<String> append(List<String> components, String ... others) {
        return ImmutableList.builder().addAll(components).add((Object[])others).build();
    }

    private List<String> components(String ... others) {
        return Arrays.asList(others);
    }

    private List<String> restComponents(String ... others) {
        return this.append(Arrays.asList(REST, API, "1.0"), others);
    }

    private List<String> adminComponents(String ... others) {
        return this.append(Arrays.asList(ADMIN), others);
    }

    private List<String> databaseComponents(String ... others) {
        return this.append(Arrays.asList(ADMIN, DB), others);
    }

    private List<String> licensingComponents(String ... others) {
        return this.append(Arrays.asList(ADMIN, LICENSE), others);
    }

    private List<String> usersComponents(String ... others) {
        return this.append(Arrays.asList(ADMIN, USERS), others);
    }

    private List<String> groupsComponents(String ... others) {
        return this.append(Arrays.asList(ADMIN, GROUPS), others);
    }

    private List<String> pluginsServletComponents(String ... others) {
        return this.append(Arrays.asList(PLUGINS, SERVLET), others);
    }

    private List<String> projectsComponents() {
        return Arrays.asList(PROJECTS);
    }

    private List<String> projectComponents(String projectKey, String ... others) {
        return this.projectComponents(false, projectKey, others);
    }

    private List<String> projectComponents(boolean usePersonalProjectPath, String projectKey, String ... others) {
        if (InternalPersonalProject.isPersonalProjectKey((String)projectKey) && usePersonalProjectPath) {
            return ImmutableList.builder().add((Object[])new String[]{USERS, InternalPersonalProject.getPersonalProjectOwner((String)projectKey)}).add((Object[])others).build();
        }
        return ImmutableList.builder().addAll((Iterable)this.projectsComponents()).add((Object)projectKey).add((Object[])others).build();
    }

    private List<String> repoComponents(String projectKey, String repoSlug, String ... others) {
        return this.append(this.projectComponents(true, projectKey, new String[]{REPOS, repoSlug}), others);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI getBaseUrl() {
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(NavBuilderImpl.class.getClassLoader());
            URI uRI = this.applicationPropertiesService.getBaseUrl();
            return uRI;
        }
        finally {
            currentThread.setContextClassLoader(original);
        }
    }

    static /* synthetic */ ThreadLocal access$000(NavBuilderImpl x0) {
        return x0.requestConfiguration;
    }

    static /* synthetic */ List access$100(NavBuilderImpl x0, String[] x1) {
        return x0.components(x1);
    }

    static /* synthetic */ List access$400(NavBuilderImpl x0, List x1, String[] x2) {
        return x0.append(x1, x2);
    }

    static /* synthetic */ Function access$500() {
        return ENCODE_PATH;
    }

    static /* synthetic */ List access$700(NavBuilderImpl x0, String[] x1) {
        return x0.adminComponents(x1);
    }

    static /* synthetic */ List access$800(NavBuilderImpl x0, String[] x1) {
        return x0.pluginsServletComponents(x1);
    }

    static /* synthetic */ List access$900(NavBuilderImpl x0, String[] x1) {
        return x0.databaseComponents(x1);
    }

    static /* synthetic */ List access$1000(NavBuilderImpl x0, String[] x1) {
        return x0.licensingComponents(x1);
    }

    static /* synthetic */ List access$1100(NavBuilderImpl x0, String[] x1) {
        return x0.usersComponents(x1);
    }

    static /* synthetic */ List access$1200(NavBuilderImpl x0, String[] x1) {
        return x0.groupsComponents(x1);
    }

    static /* synthetic */ List access$1300(NavBuilderImpl x0, String[] x1) {
        return x0.restComponents(x1);
    }

    static /* synthetic */ List access$1500(NavBuilderImpl x0) {
        return x0.projectsComponents();
    }

    static /* synthetic */ List access$1600(NavBuilderImpl x0, String x1, String x2, String[] x3) {
        return x0.repoComponents(x1, x2, x3);
    }

    static /* synthetic */ List access$1700(NavBuilderImpl x0, boolean x1, String x2, String[] x3) {
        return x0.projectComponents(x1, x2, x3);
    }

    static /* synthetic */ List access$1800(NavBuilderImpl x0, String x1, String[] x2) {
        return x0.projectComponents(x1, x2);
    }

    static /* synthetic */ Function access$2100() {
        return ENCODE_PATH_FOR_SHELL;
    }

    static /* synthetic */ URI access$2200(NavBuilderImpl x0) {
        return x0.buildBaseUri();
    }

    static /* synthetic */ Logger access$2300() {
        return log;
    }

    static /* synthetic */ StashAuthenticationContext access$2400(NavBuilderImpl x0) {
        return x0.stashAuthenticationContext;
    }
}

