/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson.handler.exception;

import com.atlassian.stash.Product;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.johnson.AbstractHelpPathProvider;
import com.atlassian.stash.internal.johnson.handler.EventDetails;
import com.atlassian.stash.internal.johnson.handler.exception.ExceptionFailureHandler;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public class ConnectionFailureHandler
extends AbstractHelpPathProvider
implements ExceptionFailureHandler {
    public EventDetails handle(@Nonnull Throwable t) {
        StringBuilder message = new StringBuilder("The database, as currently configured, is not accessible.");
        SQLException e = (SQLException)t.getCause();
        String eMessage = e.getMessage();
        if (eMessage.contains(ClassNotFoundException.class.getName())) {
            for (DbType dbType : DbType.values()) {
                if (!eMessage.contains(ClassNotFoundException.class.getName() + ": " + dbType.getDriverClassName())) continue;
                AbstractHelpPathProvider.HelpDetails help = this.getHelp(dbType.getHelpKey(), "our documentation", "https://confluence.atlassian.com/x/qAqTE");
                message.append(Product.NAME).append(" is configured to use the ").append(dbType.getKey()).append(" driver (").append(dbType.getDriverClassName()).append(") but it is not available. Please follow the instructions to install the driver as per <a href=\"").append(help.getUrl()).append("\">").append(help.getTitle()).append("</a>.");
            }
        }
        return new EventDetails("database-unavailable", message.toString(), t);
    }
}

