/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="johnsonPluginEventListener")
public class JohnsonPluginEventListener {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ApplicationSettings applicationSettings;

    @Autowired
    public JohnsonPluginEventListener(EventPublisher eventPublisher, I18nService i18nService, ApplicationSettings applicationSettings) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.applicationSettings = applicationSettings;
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent e) {
        PluginAccessor pluginAccessor = e.getPluginAccessor();
        for (String key : this.applicationSettings.getRequiredPluginKeys()) {
            Event event;
            Plugin plugin = pluginAccessor.getPlugin(key);
            if (plugin == null) {
                event = new Event(EventType.get((String)"plugin-failed"), this.i18nService.getMessage("stash.web.plugin.failed.install", new Object[]{key}), EventLevel.get((String)"error"));
                this.eventPublisher.publish((Object)new AddEvent((Object)this, event));
                continue;
            }
            if (plugin.getPluginState() == PluginState.ENABLED) continue;
            event = new Event(EventType.get((String)"plugin-failed"), this.i18nService.getMessage("stash.web.plugin.failed.enable", new Object[]{key}), EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, event));
        }
    }
}

