/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.ApplicationEventCheck;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.Product;
import com.atlassian.stash.internal.home.HomeDirectoryDetails;
import com.atlassian.stash.internal.home.HomeDirectoryResolver;
import com.atlassian.stash.util.FileUtils;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeApplicationEventCheck
implements ApplicationEventCheck {
    private static final Logger LOG = LoggerFactory.getLogger(HomeApplicationEventCheck.class);
    private static final String HELP_LINK = ": <a href=\"http://confluence.atlassian.com/x/GpAJEQ\">Help</a>";

    public void check(JohnsonEventContainer eventContainer, ServletContext servletContext) {
        HomeDirectoryDetails homeDirectoryDetails;
        try {
            homeDirectoryDetails = this.resolveHomeDirectory();
        }
        catch (IllegalStateException e) {
            this.addError(eventContainer, e.getMessage());
            return;
        }
        File home = homeDirectoryDetails.getHome();
        if (!home.exists()) {
            String message = this.formatErrorMessage("%1$s %3$s [%2$s] cannot be created or %1$s does not have permission to access it", home, "Home");
            this.addError(eventContainer, message);
            return;
        }
        if (!this.verify(eventContainer, home, "Home")) {
            return;
        }
        File sharedHome = homeDirectoryDetails.getSharedHome();
        if (!sharedHome.exists()) {
            try {
                FileUtils.mkdir((File)sharedHome);
            }
            catch (IllegalStateException e) {
                this.addError(eventContainer, e.getMessage());
                return;
            }
        }
        this.verify(eventContainer, sharedHome, "Shared Home");
    }

    private boolean verify(JohnsonEventContainer eventContainer, File dir, String dirName) {
        String messageTemplate = null;
        if (!dir.isDirectory()) {
            messageTemplate = "%1$s %3$s [%2$s] is not a directory";
        } else if (!dir.canRead()) {
            messageTemplate = "%1$s %3$s [%2$s] exists but is not readable by %1$s";
        } else if (!this.isWritable(dir)) {
            messageTemplate = "%1$s %3$s [%2$s] exists but is not writable by %1$s";
        } else if (!dir.canExecute()) {
            messageTemplate = "%1$s %3$s [%2$s] exists but is not accessible by %1$s";
        }
        if (messageTemplate != null) {
            String message = this.formatErrorMessage(messageTemplate, dir, dirName);
            this.addError(eventContainer, message);
        }
        return messageTemplate == null;
    }

    private String formatErrorMessage(String template, File dir, String dirName) {
        return String.format(template, Product.NAME, dir, dirName);
    }

    private void addError(JohnsonEventContainer eventContainer, String message) {
        LOG.error(message);
        eventContainer.addEvent(new Event(EventType.get((String)"home"), message, EventLevel.get((String)"fatal")));
    }

    private boolean isWritable(File home) {
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                File f = File.createTempFile(Product.NAME, ".tmp", home);
                if (!f.delete()) {
                    f.deleteOnExit();
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return home.canWrite();
    }

    protected HomeDirectoryDetails resolveHomeDirectory() {
        return new HomeDirectoryResolver().resolve();
    }
}

