/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.stash.help.HelpPathService;
import com.atlassian.stash.internal.johnson.AbstractHelpPathProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractHelpPathProvider {
    private HelpPathService helpPathService;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean uninitialised = true;

    protected HelpDetails getHelp(String key, String defaultTitle, String defaultUrl) {
        String title = null;
        String url = null;
        HelpPathService service = this.getHelpPathService();
        if (service != null) {
            title = service.getPageTitle(key);
            url = service.getPageUrl(key);
        }
        return new HelpDetails(StringUtils.defaultIfBlank((String)title, (String)defaultTitle), StringUtils.defaultIfBlank((String)url, (String)defaultUrl), null);
    }

    private HelpPathService getHelpPathService() {
        if (this.uninitialised) {
            this.uninitialised = false;
            try {
                InputStream resourceAsStream = new ClassPathResource("help-paths.properties").getInputStream();
                Properties helpPaths = new Properties();
                helpPaths.load(resourceAsStream);
                this.helpPathService = new /* Unavailable Anonymous Inner Class!! */;
            }
            catch (IOException e) {
                this.log.warn("Could not load help path configuration. Help links will use default URLs", (Throwable)e);
            }
        }
        return this.helpPathService;
    }
}

