/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm.git;

import com.atlassian.stash.scm.git.GitDiffHeaderType;
import com.atlassian.stash.scm.git.GitDiffTarget;

public enum GitDiffHeader {
    COPY_FROM("copy from", GitDiffHeaderType.PATH, GitDiffTarget.SOURCE),
    COPY_TO("copy to", GitDiffHeaderType.PATH, GitDiffTarget.DESTINATION),
    DELETED_FILE_MODE("deleted file mode", GitDiffHeaderType.MODE, GitDiffTarget.SOURCE),
    DISSIMILARITY_INDEX("dissimilarity index", GitDiffHeaderType.PERCENTAGE),
    INDEX("index", GitDiffHeaderType.INDEX),
    NEW_FILE_MODE("new file mode", GitDiffHeaderType.MODE, GitDiffTarget.DESTINATION),
    NEW_MODE("new mode", GitDiffHeaderType.MODE, GitDiffTarget.DESTINATION),
    OLD_MODE("old mode", GitDiffHeaderType.MODE, GitDiffTarget.SOURCE),
    RENAME_FROM("rename from", GitDiffHeaderType.PATH, GitDiffTarget.SOURCE),
    RENAME_TO("rename to", GitDiffHeaderType.PATH, GitDiffTarget.DESTINATION),
    SIMILARITY_INDEX("similarity index", GitDiffHeaderType.PERCENTAGE);

    private final String key;
    private final GitDiffTarget target;
    private final GitDiffHeaderType type;

    private GitDiffHeader(String key, GitDiffHeaderType type) {
        this(key, type, GitDiffTarget.NONE);
    }

    private GitDiffHeader(String key, GitDiffHeaderType type, GitDiffTarget target) {
        type.verify(target);
        this.key = key;
        this.target = target;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public GitDiffTarget getTarget() {
        return this.target;
    }

    public GitDiffHeaderType getType() {
        return this.type;
    }

    public String getValue(String line) {
        return line.substring(this.key.length() + 1);
    }
}

