/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.nav;

import com.atlassian.stash.content.Path;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryVisibility;
import com.atlassian.stash.user.StashUser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface NavBuilder {
    public static final String BASE_URL_KEY = "stash.baseUrl%";
    public static final String TOKEN_PREFIX = "$$$$";
    public static final String TOKEN_SUFFIX = "$$$$";
    public static final String BASE_URL_TOKEN = "$$$$stash.baseUrl%$$$$";
    public static final String USE_BASE_URL_TOKEN = "useBaseUrlToken";

    public String buildAbsolute();

    public String buildConfigured();

    public String buildBaseUrl();

    public String buildRelative();

    public Admin admin();

    public Builder<?> about();

    public PluginServlets pluginServlets();

    public Rest rest();

    public Tmp tmp();

    public Addons addons();

    public Project project(@Nonnull String var1);

    public Project project(@Nonnull com.atlassian.stash.project.Project var1);

    public Repo repo(@Nonnull Repository var1);

    public Login login();

    public Builder<?> logout();

    public Builder<?> signup();

    public Builder<?> captcha();

    public Builder<?> retrievePassword();

    public Builder<?> passwordReset();

    public Profile profile();

    public Profile user(StashUser var1);

    public Profile userBySlug(String var1);

    public Builder<?> securityCheck();

    public Builder<?> xsrfNotification();

    @Deprecated
    public Builder<?> welcome();

    public Builder<?> setup();

    public ListProjects allProjects();

    public GlobalListRepos allRepos();

    public CreateProject createProject();

    public UserAccount account();

    public GettingStarted gettingStarted();

    public static interface GettingStarted
    extends NavigationStep<GettingStarted> {
    }

    public static interface Login
    extends NavigationStep<Login> {
        @Nonnull
        public Login embedded();

        @Nonnull
        public Login admin();

        @Nonnull
        public Login sysadmin();
    }

    public static interface NavigationStep<B extends NavigationStep>
    extends Builder<B> {
        @Nonnull
        public Builder<?> next();

        @Nonnull
        public Builder<?> next(@Nonnull String var1);
    }

    public static interface AddonRequests
    extends Builder<AddonRequests> {
        public Builder<?> category(String var1);
    }

    public static interface Addons
    extends Builder<Addons> {
        public Builder<?> manage();

        public AddonRequests requests();
    }

    public static interface Tmp
    extends Builder<Tmp> {
        public Builder<?> avatar(@Nonnull String var1);
    }

    public static interface ListPullRequests
    extends PagedBuilder<ListPullRequests> {
        public Builder<?> open();

        public Builder<?> declined();

        public Builder<?> merged();

        public ListPullRequests incoming();

        public ListPullRequests outgoing();
    }

    public static interface PullRequestOverview
    extends PagedBuilder<PullRequestOverview> {
        public Builder<?> comment(long var1);

        public Builder<?> activity(long var1);
    }

    public static interface PullRequest
    extends Builder<PullRequest> {
        public Changeset changeset(@Nonnull String var1);

        public PagedBuilder<?> commits();

        public Builder<?> diff();

        public PullRequestOverview overview();

        public PagedBuilder<?> unwatch();
    }

    public static interface CreatePullRequest
    extends Builder<CreatePullRequest> {
        public CreatePullRequest sourceBranch(String var1);

        public CreatePullRequest targetBranch(String var1);
    }

    public static interface RepoFork
    extends Builder<RepoFork> {
    }

    @Deprecated
    public static interface RepoClone
    extends Builder<RepoClone> {
        public String buildAbsoluteWithUsername();

        public String buildAbsoluteWithUsernameFor(StashUser var1);

        public String buildAbsoluteWithoutUsername();
    }

    public static interface RevisionBrowse
    extends PathBuilder<RevisionBrowse> {
    }

    public static interface RepoDelete
    extends Builder<RepoDelete> {
    }

    public static interface RepoHooks
    extends Builder<RepoHooks> {
    }

    public static interface PullRequestRepoSettings
    extends Builder<PullRequestRepoSettings> {
    }

    public static interface RepoPermissions
    extends Builder<RepoPermissions> {
    }

    public static interface RepoSettings
    extends Builder<RepoSettings> {
        public PullRequestRepoSettings pullRequests();
    }

    public static interface CompareBuilder<T extends CompareBuilder>
    extends Builder<T> {
        public CompareBuilder sourceBranch(@Nonnull String var1);

        public CompareBuilder targetBranch(@Nonnull String var1);
    }

    public static interface Compare
    extends CompareBuilder<Compare>,
    PathBuilder<Compare> {
        public CommitsBuilder commits();

        public DiffBuilder diff();

        public static interface DiffBuilder
        extends CompareBuilder<DiffBuilder> {
        }

        public static interface CommitsBuilder
        extends CompareBuilder<CommitsBuilder> {
        }
    }

    public static interface RepoAttachments
    extends Builder<RepoAttachments> {
        public Builder<?> attachment(@Nonnull String var1);
    }

    public static interface Changeset
    extends PathBuilder<Changeset> {
        public Changeset change(Path var1);

        public Builder<?> comment(long var1);

        public PagedBuilder<?> unwatch();
    }

    public static interface ListCommits
    extends PagedBuilder<ListCommits> {
        public ListCommits until(@Nonnull Ref var1);

        public ListCommits until(@Nonnull String var1);
    }

    public static interface ListTags
    extends PagedBuilder<ListTags> {
    }

    public static interface ListBranches
    extends PagedBuilder<ListBranches> {
    }

    public static interface CreateRepo
    extends Builder<CreateRepo> {
    }

    public static interface BrowseRepoResource
    extends PathBuilder<BrowseRepoResource> {
        public RevisionBrowse atRevision(@Nullable String var1);

        public RevisionBrowse atRevision(@Nonnull Ref var1);
    }

    public static interface Repo
    extends Builder<Repo> {
        public RepoAttachments attachments();

        public BrowseRepoResource browse();

        public ListBranches branches();

        public ListTags tags();

        public ListCommits commits();

        public Compare compare();

        public Changeset changeset(@Nonnull String var1);

        public RepoSettings settings();

        public RepoHooks hooks();

        public RepoPermissions permissions();

        public RepoDelete delete();

        @Deprecated
        public RepoClone clone(String var1);

        public RepoFork fork();

        public CreatePullRequest createPullRequest();

        public PullRequest pullRequest(long var1);

        public ListPullRequests pullRequests();
    }

    public static interface ProjectPermissions
    extends Builder<ProjectPermissions> {
    }

    public static interface ProjectDelete
    extends Builder<ProjectDelete> {
    }

    public static interface CreateProject
    extends Builder<CreateProject> {
    }

    public static interface ProjectSettings
    extends Builder<ProjectSettings> {
    }

    public static interface ListRepos
    extends PagedBuilder<ListRepos> {
    }

    public static interface Project
    extends Builder<Project> {
        public Builder<?> avatar(int var1);

        public ListRepos repos();

        public Repo repo(@Nonnull String var1);

        public Repo repo(@Nonnull Repository var1);

        public CreateRepo createRepo();

        public ProjectSettings settings();

        public ProjectDelete delete();

        public ProjectPermissions permissions();
    }

    public static interface GlobalListRepos
    extends Builder<GlobalListRepos> {
        public GlobalListRepos privateVisibility();

        public GlobalListRepos publicVisibility();

        public GlobalListRepos visibility(RepositoryVisibility var1);
    }

    public static interface ListProjects
    extends PagedBuilder<ListProjects> {
    }

    public static interface RestAdmin
    extends Builder<RestAdmin> {
        public Builder<?> users();
    }

    public static interface RestUser
    extends Builder<RestUser> {
        public Builder<?> avatar();
    }

    public static interface RestUsers
    extends Builder<RestUsers> {
    }

    public static interface RestHook
    extends Builder<RestHook> {
        public Builder<?> avatar(@Nullable String var1);
    }

    public static interface RestHooks
    extends Builder<RestHooks> {
        public RestHook hook(@Nonnull String var1);
    }

    public static interface Rest
    extends Builder<Rest> {
        public RestAdmin admin();

        public RestUsers users();

        public RestUser users(String var1);

        public Builder<?> pullRequest(long var1);

        public RestHooks hooks();
    }

    public static interface PluginServlets
    extends PathBuilder<PluginServlets> {
        public Builder<?> oauthTokens();

        public Builder<?> notificationSettings();
    }

    public static interface ViewGroup
    extends Builder<ViewGroup> {
    }

    public static interface DeleteGroup
    extends Builder<DeleteGroup> {
    }

    public static interface Groups
    extends PagedBuilder<Groups> {
        public Builder<?> create();

        public DeleteGroup delete(String var1);

        public ViewGroup view(String var1);

        public Groups filter(String var1);
    }

    public static interface DeleteUser
    extends Builder<DeleteUser> {
    }

    public static interface ViewUser
    extends Builder<ViewUser> {
        public Builder<?> listSshKeys();
    }

    public static interface Users
    extends PagedBuilder<Users> {
        public Builder<?> create();

        public DeleteUser delete(String var1);

        public ViewUser view(String var1);

        public Users filter(String var1);

        public Builder<?> captcha(String var1);
    }

    public static interface Licensing
    extends Builder<Licensing> {
        public Builder<?> edit();
    }

    public static interface Database
    extends Builder<Database> {
        public Builder<?> migrate();
    }

    public static interface Admin
    extends Builder<Admin> {
        public Users users();

        public Groups groups();

        public Builder<?> security();

        public Builder<?> plugins();

        public Builder<?> settings();

        public Builder<?> permissions();

        public Builder<?> avatars();

        public Builder<?> authentication();

        public Builder<?> mailServer();

        public Builder<?> appLinks();

        public Builder<?> serverSettings();

        public Database database();

        public Licensing licensing();

        public Builder<?> i18n();

        public Builder<?> logging();

        public Builder<?> sysInfo();

        public Builder<?> clustering();
    }

    public static interface UserAccount
    extends Builder<UserAccount> {
        public Builder<?> settings();

        public Builder<?> password();
    }

    public static interface Profile
    extends Builder<Profile> {
        public Builder<?> avatar(int var1);

        public Builder<?> listSshKeys();
    }

    public static interface PathBuilder<B extends PathBuilder>
    extends Builder<B> {
        public PathBuilder<B> path(String ... var1);

        public PathBuilder<B> path(@Nonnull Path var1);
    }

    public static interface PagedBuilder<B extends PagedBuilder>
    extends Builder<B> {
        public PagedBuilder<B> startAt(int var1);

        public PagedBuilder<B> withLimit(int var1);
    }

    public static interface Builder<B extends Builder> {
        public Builder<B> withParam(@Nonnull String var1, String var2);

        public String buildRelative();

        public String buildRelNoContext();

        public String buildAbsolute();

        public String buildConfigured();
    }
}

