/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.event.permission;

import com.atlassian.stash.event.annotation.TransactionAware;
import com.atlassian.stash.event.permission.PermissionRevocationRequestedEvent;
import com.atlassian.stash.event.permission.ProjectPermissionEvent;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.CancelState;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@TransactionAware(value=TransactionAware.When.IMMEDIATE)
public class ProjectPermissionRevocationRequestedEvent
extends ProjectPermissionEvent
implements PermissionRevocationRequestedEvent {
    private final CancelState cancelState;

    public ProjectPermissionRevocationRequestedEvent(@Nonnull Object source, @Nonnull Permission permission, @Nonnull Project project, @Nullable String affectedGroup, @Nullable StashUser affectedUser, @Nonnull CancelState cancelState) {
        super(source, permission, project, affectedGroup, affectedUser);
        this.cancelState = (CancelState)Preconditions.checkNotNull((Object)cancelState, (Object)"cancelState");
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

