/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.commit;

import com.atlassian.stash.commit.Changeset;
import com.atlassian.stash.commit.Commit;
import com.atlassian.stash.commit.MinimalCommit;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.util.Page;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleChangeset
implements Changeset {
    private final MinimalCommit fromCommit;
    private final Commit toCommit;
    private final Page<Change> changes;

    private SimpleChangeset(Builder builder) {
        this.fromCommit = builder.fromCommit;
        this.toCommit = builder.toCommit;
        this.changes = builder.changes;
    }

    @Override
    public Page<Change> getChanges() {
        return this.changes;
    }

    @Override
    public MinimalCommit getFromCommit() {
        return this.fromCommit;
    }

    @Override
    @Nonnull
    public Commit getToCommit() {
        return this.toCommit;
    }

    public static class Builder {
        private final Commit toCommit;
        private Page<Change> changes;
        private MinimalCommit fromCommit;

        public Builder(@Nonnull Commit toCommit) {
            this.toCommit = (Commit)Preconditions.checkNotNull((Object)toCommit, (Object)"toCommit");
        }

        @Nonnull
        public SimpleChangeset build() {
            return new SimpleChangeset(this);
        }

        @Nonnull
        public Builder changes(@Nullable Page<Change> value) {
            this.changes = value;
            return this;
        }

        @Nonnull
        public Builder fromCommit(@Nullable MinimalCommit value) {
            this.fromCommit = value;
            return this;
        }
    }
}

