/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.commit;

import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitsRequest {
    private final String commitId;
    private final Set<String> paths;
    private final Set<String> propertyKeys;
    private final Repository repository;

    private CommitsRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.paths = builder.paths.build();
        this.propertyKeys = builder.propertyKeys.build();
        this.repository = builder.repository;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.propertyKeys;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final ImmutableSet.Builder<String> paths;
        private final ImmutableSet.Builder<String> propertyKeys;
        private final Repository repository;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId) {
            this.commitId = Builder.checkNotBlank(commitId, "commitId");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.paths = ImmutableSet.builder();
            this.propertyKeys = ImmutableSet.builder();
        }

        @Nonnull
        public CommitsRequest build() {
            return new CommitsRequest(this);
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        @Nonnull
        public Builder propertyKey(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value);
            return this;
        }

        @Nonnull
        public Builder propertyKeys(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, values);
            return this;
        }

        @Nonnull
        public Builder propertyKeys(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value, values);
            return this;
        }
    }
}

