/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class PageRequestImpl
implements PageRequest {
    private final int start;
    private final int limit;

    public PageRequestImpl(int start, int limit) {
        this.start = start < 0 ? 0 : start;
        this.limit = limit <= 0 ? 1 : limit;
        Preconditions.checkArgument((this.limit <= 0x100000 ? 1 : 0) != 0, (Object)"Limit must be less than 1048576");
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.limit;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRequestImpl other = (PageRequestImpl)obj;
        if (this.limit != other.limit) {
            return false;
        }
        return this.start == other.start;
    }

    @Override
    @Nonnull
    public PageRequest buildRestrictedPageRequest(int maxLimit) {
        return new PageRequestImpl(this.start, Math.min(this.limit, maxLimit));
    }
}

