/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;

public class FilteredPageImpl<T>
implements Page<T> {
    private final PageRequest pageRequest;
    private final int size;
    private final SortedMap<Integer, T> valueMap;
    private final boolean lastPage;
    private final int nextOrdinal;

    public FilteredPageImpl(@Nonnull PageRequest pageRequest, int size, @Nonnull SortedMap<Integer, T> valueMap, boolean lastPage) {
        this.pageRequest = pageRequest;
        this.size = size;
        this.lastPage = lastPage;
        if (valueMap.size() > size) {
            this.nextOrdinal = (Integer)Iterables.get(valueMap.keySet(), (int)size);
            this.valueMap = valueMap.headMap(this.nextOrdinal);
        } else {
            this.valueMap = valueMap;
            this.nextOrdinal = !valueMap.isEmpty() ? valueMap.lastKey() + 1 : -1;
        }
    }

    @Override
    public int getStart() {
        return this.pageRequest.getStart();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getLimit() {
        return this.pageRequest.getLimit();
    }

    @Override
    public boolean getIsLastPage() {
        return this.lastPage;
    }

    @Override
    @Nonnull
    public Iterable<T> getValues() {
        return this.valueMap.values();
    }

    @Override
    public PageRequest getNextPageRequest() {
        if (this.lastPage) {
            return null;
        }
        return new PageRequestImpl(this.nextOrdinal, this.pageRequest.getLimit());
    }

    @Override
    public SortedMap<Integer, T> getOrdinalIndexedValues() {
        return this.valueMap;
    }

    @Override
    @Nonnull
    public <E> FilteredPageImpl<E> transform(@Nonnull Function<? super T, ? extends E> transformFunction) {
        TreeMap transformedValueMap = new TreeMap(Maps.transformValues(this.valueMap, transformFunction));
        return new FilteredPageImpl(this.pageRequest, this.size, transformedValueMap, this.lastPage);
    }
}

