/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.scm.CommandResult;
import com.atlassian.stash.util.AbstractSummary;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageImpl;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Preconditions;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractPagedSummary
extends AbstractSummary {
    private final boolean lastPage;
    private final PageRequest pageRequest;
    private final int size;

    protected AbstractPagedSummary(@Nonnull AbstractPagedBuilder<?, ?> builder) {
        super(builder);
        this.lastPage = ((AbstractPagedBuilder)builder).lastPage;
        this.pageRequest = ((AbstractPagedBuilder)builder).buildPageRequest();
        this.size = ((AbstractPagedBuilder)builder).size;
    }

    @Deprecated
    @Nonnull
    public Page<Void> asPage() {
        return new PageImpl<Void>(this.getPageRequest(), this.getSize(), Collections.emptyList(), this.isLastPage());
    }

    @Nullable
    public PageRequest getNextPageRequest() {
        if (this.isLastPage()) {
            return null;
        }
        PageRequest pageRequest = this.getPageRequest();
        return new PageRequestImpl(pageRequest.getStart() + pageRequest.getLimit(), pageRequest.getLimit());
    }

    @Nonnull
    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isLastPage() {
        return this.lastPage;
    }

    public static abstract class AbstractPagedBuilder<B extends AbstractPagedBuilder<B, S>, S extends AbstractPagedSummary>
    extends AbstractSummary.AbstractBuilder<B, S> {
        private boolean lastPage;
        private PageRequest pageRequest;
        private int size;

        protected AbstractPagedBuilder(@Nonnull AbstractSummary summary) {
            super(summary);
            if (summary instanceof AbstractPagedSummary) {
                AbstractPagedSummary pageSummary = (AbstractPagedSummary)summary;
                this.lastPage = pageSummary.isLastPage();
                this.pageRequest = pageSummary.getPageRequest();
                this.size = pageSummary.getSize();
            }
        }

        protected AbstractPagedBuilder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        public B lastPage(boolean value) {
            this.lastPage = value;
            return (B)((AbstractPagedBuilder)this.self());
        }

        @Nonnull
        public B pageRequest(@Nonnull PageRequest value) {
            this.pageRequest = (PageRequest)Preconditions.checkNotNull((Object)value, (Object)"pageRequest");
            return (B)((AbstractPagedBuilder)this.self());
        }

        @Nonnull
        public B size(int value) {
            this.size = value;
            return (B)((AbstractPagedBuilder)this.self());
        }

        @Nonnull
        private PageRequest buildPageRequest() {
            return this.pageRequest == null ? new PageRequestImpl(0, 25) : this.pageRequest;
        }
    }
}

