/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestRef;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ObjectUtils;

public class ChangesetsBetweenRequest {
    private final Set<String> excludes;
    private final Set<String> includes;
    private final Set<String> loadAttributes;
    private final Set<String> paths;
    private final Repository repository;
    private final Repository secondaryRepository;

    private ChangesetsBetweenRequest(Repository repository, Repository secondaryRepository, Set<String> includes, Set<String> excludes, Set<String> paths, Set<String> loadAttributes) {
        this.excludes = excludes;
        this.includes = includes;
        this.loadAttributes = loadAttributes;
        this.paths = paths;
        this.repository = repository;
        this.secondaryRepository = secondaryRepository;
    }

    @Nonnull
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Nonnull
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Nonnull
    public Set<String> getLoadAttributes() {
        return this.loadAttributes;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> excludes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> includes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> loadAttributes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private final Repository repository;
        private Repository secondaryRepository;

        public Builder(Repository repository) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        }

        public Builder(ChangesetsBetweenRequest request) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)((ChangesetsBetweenRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getRepository(), (Object)"request.repository");
            this.exclude(request.getExcludes()).include(request.getIncludes()).loadAttributes(request.getLoadAttributes()).paths(request.getPaths()).secondaryRepository(request.getSecondaryRepository());
        }

        public Builder(PullRequest pullRequest) {
            Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest");
            PullRequestRef fromRef = (PullRequestRef)Preconditions.checkNotNull((Object)pullRequest.getFromRef(), (Object)"pullRequest.fromRef");
            PullRequestRef toRef = (PullRequestRef)Preconditions.checkNotNull((Object)pullRequest.getToRef(), (Object)"pullRequest.toRef");
            this.repository = (Repository)Preconditions.checkNotNull((Object)toRef.getRepository(), (Object)"pullRequest.toRef.repository");
            this.exclude((String)Preconditions.checkNotNull((Object)toRef.getLatestChangeset(), (Object)"pullRequest.toRef.latestChangeset"), new String[0]).include((String)Preconditions.checkNotNull((Object)fromRef.getLatestChangeset(), (Object)"pullRequest.fromRef.latestChangeset"), new String[0]);
            if (pullRequest.isCrossRepository()) {
                this.secondaryRepository((Repository)Preconditions.checkNotNull((Object)fromRef.getRepository(), (Object)"pullRequest.fromRef.repository"));
            }
        }

        public ChangesetsBetweenRequest build() {
            ImmutableSet include = this.includes.build();
            if (include.isEmpty()) {
                throw new IllegalStateException("At least one changeset must be provided to include");
            }
            return new ChangesetsBetweenRequest(this.repository, this.secondaryRepository, (Set)include, (Set)this.excludes.build(), (Set)this.paths.build(), (Set)this.loadAttributes.build());
        }

        public Builder exclude(String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.excludes, value, values);
            return this;
        }

        public Builder exclude(Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.excludes, values);
            return this;
        }

        public Builder include(String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.includes, value, values);
            return this;
        }

        public Builder include(Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.includes, values);
            return this;
        }

        public Builder loadAttribute(String value) {
            Builder.addIf(NOT_BLANK, this.loadAttributes, value);
            return this;
        }

        public Builder loadAttributes(Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.loadAttributes, values);
            return this;
        }

        public Builder loadAttributes(String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.loadAttributes, value, values);
            return this;
        }

        public Builder path(String value) {
            Builder.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        public Builder paths(Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        public Builder paths(String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        public Builder secondaryRepository(Repository value) {
            if (value != null && ObjectUtils.notEqual((Object)this.repository.getHierarchyId(), (Object)value.getHierarchyId())) {
                throw new IllegalStateException("Repository " + value.getProject().getKey() + "/" + value.getSlug() + " is not from the same hierarchy as " + this.repository.getProject().getKey() + "/" + this.repository.getSlug() + "; only repositories from the same hierarchy may be compared.");
            }
            this.secondaryRepository = value;
            return this;
        }
    }
}

