/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.compare;

import com.atlassian.stash.compare.CompareDiffRequest;
import com.atlassian.stash.compare.CompareRef;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class CompareRequest {
    private final CompareRef fromRef;
    private final CompareRef toRef;

    private CompareRequest(@Nonnull Builder builder) {
        this.fromRef = builder.fromRef;
        this.toRef = builder.toRef;
    }

    @Nonnull
    public CompareRef getFromRef() {
        return this.fromRef;
    }

    @Nonnull
    public CompareRef getToRef() {
        return this.toRef;
    }

    public static class Builder {
        private CompareRef fromRef;
        private CompareRef toRef;

        public Builder() {
        }

        public Builder(CompareDiffRequest request) {
            this.fromRef = request.getFromRef();
            this.toRef = request.getToRef();
        }

        @Nonnull
        public CompareRequest build() {
            Preconditions.checkArgument((this.fromRef != null && this.toRef != null ? 1 : 0) != 0, (Object)"both a source and target ref are required");
            return new CompareRequest(this);
        }

        @Nonnull
        public Builder fromRef(CompareRef fromRef) {
            this.fromRef = (CompareRef)Preconditions.checkNotNull((Object)fromRef, (Object)"fromRef");
            return this;
        }

        @Nonnull
        public Builder fromRef(String id, Repository repository) {
            return this.fromRef(new CompareRef(id, repository));
        }

        @Nonnull
        public Builder toRef(CompareRef toRef) {
            this.toRef = (CompareRef)Preconditions.checkNotNull((Object)toRef, (Object)"toRef");
            return this;
        }

        @Nonnull
        public Builder toRef(String id, Repository repository) {
            return this.toRef(new CompareRef(id, repository));
        }
    }
}

