/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.AsynchronousPreferred;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.event.RepositoryRefsChangedEvent;
import com.atlassian.stash.event.pull.PullRequestEvent;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.repository.RefChange;
import com.atlassian.stash.repository.RefChangeType;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.SimpleRefChange;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.pullrequest.merged")
public class PullRequestMergedEvent
extends PullRequestEvent
implements RepositoryRefsChangedEvent {
    private final MinimalChangeset changeset;
    private final Collection<RefChange> refChanges;

    public PullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nullable MinimalChangeset changeset) {
        super(source, pullRequest, PullRequestAction.MERGED);
        this.changeset = changeset;
        this.refChanges = changeset == null ? Collections.emptyList() : Collections.singleton(new SimpleRefChange.Builder().from(pullRequest.getToRef()).toHash(changeset.getId()).type(RefChangeType.UPDATE).build());
    }

    @Nullable
    public MinimalChangeset getChangeset() {
        return this.changeset;
    }

    @Override
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.getPullRequest().getToRef().getRepository();
    }

    public boolean isMergedRemotely() {
        return this.changeset == null;
    }
}

