/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.validation;

import com.atlassian.stash.validation.FormErrors;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

public class SimpleFormErrors
implements FormErrors {
    private final Map<String, Collection<String>> fieldErrors;
    private final Collection<String> formErrors;

    private SimpleFormErrors(Builder builder) {
        this.fieldErrors = this.copyFieldErrors(builder.fieldErrors);
        this.formErrors = builder.formErrors.build();
    }

    @Override
    @Nonnull
    public Collection<String> getErrors(@Nonnull String field) {
        Collection<String> forField = this.fieldErrors.get(field);
        return forField != null ? forField : Collections.emptyList();
    }

    @Override
    @Nonnull
    public Map<String, Collection<String>> getFieldErrors() {
        return this.fieldErrors;
    }

    @Override
    @Nonnull
    public Collection<String> getFormErrors() {
        return this.formErrors;
    }

    @Override
    public boolean isEmpty() {
        return this.fieldErrors.isEmpty() && this.formErrors.isEmpty();
    }

    private Map<String, Collection<String>> copyFieldErrors(Map<String, ImmutableList.Builder<String>> fieldErrors) {
        return ImmutableMap.copyOf((Map)Maps.transformValues(fieldErrors, (Function)new Function<ImmutableList.Builder<String>, Collection<String>>(){

            public Collection<String> apply(ImmutableList.Builder<String> input) {
                return input.build();
            }
        }));
    }

    public static class Builder {
        private final Map<String, ImmutableList.Builder<String>> fieldErrors = Maps.newHashMap();
        private final ImmutableList.Builder<String> formErrors = ImmutableList.builder();

        public Builder fieldError(@Nonnull String field, @Nonnull String error) {
            return this.fieldErrors(field, error, new String[0]);
        }

        public Builder fieldErrors(@Nonnull String field, @Nonnull String error, String ... moreErrors) {
            Preconditions.checkNotNull((Object)field, (Object)"field");
            Preconditions.checkNotNull((Object)error, (Object)"error");
            Preconditions.checkNotNull((Object)moreErrors, (Object)"moreErrors");
            if (!this.fieldErrors.containsKey(field)) {
                this.fieldErrors.put(field, (ImmutableList.Builder<String>)ImmutableList.builder());
            }
            this.fieldErrors.get(field).add((Object)error).add((Object[])moreErrors);
            return this;
        }

        public Builder formError(@Nonnull String error) {
            return this.formErrors(error, new String[0]);
        }

        public Builder formErrors(@Nonnull String error, String ... moreErrors) {
            Preconditions.checkNotNull((Object)error, (Object)"error");
            Preconditions.checkNotNull((Object)moreErrors, (Object)"moreErrors");
            this.formErrors.add((Object)error).add((Object[])moreErrors);
            return this;
        }

        public SimpleFormErrors build() {
            return new SimpleFormErrors(this);
        }
    }
}

