/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.user;

import com.atlassian.stash.user.ServiceUser;
import com.atlassian.stash.util.BuilderSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractServiceUserRequest {
    private final boolean active;
    private final String displayName;
    private final String emailAddress;
    private final String label;
    private final String name;

    protected AbstractServiceUserRequest(AbstractBuilder builder) {
        this.active = builder.active;
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.label = builder.label;
        this.name = builder.name;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends BuilderSupport {
        private boolean active;
        private String displayName;
        private String emailAddress;
        private String label;
        private String name;

        protected AbstractBuilder() {
            this.active = true;
        }

        protected AbstractBuilder(@Nonnull ServiceUser user) {
            this.active = user.isActive();
            this.label = user.getLabel();
            this.displayName = user.getDisplayName();
            this.name = user.getName();
        }

        @Nonnull
        public B active(boolean value) {
            this.active = value;
            return this.self();
        }

        @Nonnull
        public B displayName(@Nullable String value) {
            this.displayName = value;
            return this.self();
        }

        @Nonnull
        public B emailAddress(@Nullable String value) {
            this.emailAddress = value;
            return this.self();
        }

        @Nonnull
        public B label(@Nullable String value) {
            this.label = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public B name(@Nullable String value) {
            this.name = value;
            return this.self();
        }

        protected abstract B self();
    }
}

