/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RepositoryCloneLinksRequest {
    private final Repository repository;
    private final String protocolName;
    private final StashUser user;
    private final boolean useCurrentUser;

    private RepositoryCloneLinksRequest(@Nonnull Builder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"builder");
        Preconditions.checkArgument((!builder.useCurrentUser || builder.user == null ? 1 : 0) != 0, (Object)"A user cannot be supplied if the current authenticated user is to be used for clone link generation");
        this.repository = (Repository)Preconditions.checkNotNull((Object)builder.repository, (Object)"repository");
        this.protocolName = builder.protocolName;
        this.user = builder.user;
        this.useCurrentUser = builder.useCurrentUser;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public String getProtocolName() {
        return this.protocolName;
    }

    @Nullable
    public StashUser getUser() {
        return this.user;
    }

    public boolean isUseCurrentUser() {
        return this.useCurrentUser;
    }

    public static class Builder {
        private Repository repository;
        private String protocolName;
        private StashUser user;
        private boolean useCurrentUser = true;

        public Builder repository(@Nonnull Repository value) {
            this.repository = value;
            return this;
        }

        public Builder protocol(@Nullable String value) {
            this.protocolName = value;
            return this;
        }

        public Builder user(@Nullable StashUser value) {
            this.useCurrentUser = false;
            this.user = value;
            return this;
        }

        @Nonnull
        public RepositoryCloneLinksRequest build() {
            return new RepositoryCloneLinksRequest(this);
        }
    }
}

