/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class AbstractPullRequestRequest {
    private final long pullRequestId;
    private final int repositoryId;

    public AbstractPullRequestRequest(int repositoryId, long pullRequestId) {
        this.pullRequestId = pullRequestId;
        this.repositoryId = repositoryId;
    }

    protected AbstractPullRequestRequest(@Nonnull AbstractBuilder<?> builder) {
        this.pullRequestId = builder.pullRequestId;
        this.repositoryId = builder.repositoryId;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    extends BuilderSupport {
        protected final long pullRequestId;
        protected final int repositoryId;

        protected AbstractBuilder(@Nonnull PullRequest pullRequest) {
            this(((PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest")).getToRef().getRepository().getId(), pullRequest.getId());
        }

        protected AbstractBuilder(int repositoryId, long pullRequestId) {
            this.repositoryId = repositoryId;
            this.pullRequestId = pullRequestId;
        }

        @Nonnull
        protected abstract T self();
    }
}

