/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.AbstractCommandParameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

@Deprecated
public class DetailedChangesetsRequest
extends AbstractCommandParameters {
    private final Repository repository;
    private final Iterable<String> changesetIds;
    private final int maxChangesPerCommit;
    private final boolean ignoreMissing;

    private DetailedChangesetsRequest(Repository repository, Iterable<String> changesetIds, int maxChangesPerCommit, boolean ignoreMissing) {
        this.repository = repository;
        this.changesetIds = changesetIds;
        this.maxChangesPerCommit = maxChangesPerCommit;
        this.ignoreMissing = ignoreMissing;
    }

    @Nonnull
    public Iterable<String> getChangesetIds() {
        return this.changesetIds;
    }

    public int getMaxChangesPerCommit() {
        return this.maxChangesPerCommit;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder {
        private final ImmutableList.Builder<String> changesetIds;
        private int maxChangesPerCommit;
        private boolean ignoreMissing;
        private final Repository repository;

        public Builder(@Nonnull Repository repository) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
            this.changesetIds = ImmutableList.builder();
        }

        public DetailedChangesetsRequest build() {
            if (this.maxChangesPerCommit < 1) {
                throw new IllegalStateException("The maximum number of changes to include per commit must be greater than 0");
            }
            return new DetailedChangesetsRequest(this.repository, (Iterable)this.buildChangesetIds(), this.maxChangesPerCommit, this.ignoreMissing);
        }

        public Builder changesetId(String value) {
            DetailedChangesetsRequest.addIf(NOT_BLANK, this.changesetIds, value);
            return this;
        }

        public Builder changesetIds(Iterable<String> values) {
            DetailedChangesetsRequest.addIf(NOT_BLANK, this.changesetIds, values);
            return this;
        }

        public Builder changesetIds(String value, String ... values) {
            DetailedChangesetsRequest.addIf(NOT_BLANK, this.changesetIds, value, values);
            return this;
        }

        public Builder maxChangesPerCommit(int value) {
            this.maxChangesPerCommit = value;
            return this;
        }

        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        private ImmutableList<String> buildChangesetIds() {
            ImmutableList list = this.changesetIds.build();
            if (list.isEmpty()) {
                throw new IllegalStateException("At least one changeset ID must be provided to retrieve detailed commits");
            }
            return list;
        }
    }
}

