/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.branch;

import com.atlassian.stash.event.CancelableEvent;
import com.atlassian.stash.event.StashEvent;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.repository.Branch;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.CancelState;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public abstract class BranchChangeRequestedEvent
extends StashEvent
implements CancelableEvent {
    private final Branch branch;
    private final CancelState cancelState;
    private final Repository repository;

    public BranchChangeRequestedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Branch branch, @Nonnull CancelState cancelState) {
        super(source);
        this.branch = (Branch)Preconditions.checkNotNull((Object)branch, (Object)"branch");
        this.cancelState = (CancelState)Preconditions.checkNotNull((Object)cancelState, (Object)"cancelState");
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Nonnull
    public Branch getBranch() {
        return this.branch;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

