/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.validation;

import com.atlassian.stash.validation.HttpURL;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;

public class HttpURLValidator
implements ConstraintValidator<HttpURL, String> {
    private static final String[] REQUIRED_SCHEMES = new String[]{"http", "https"};

    public void initialize(HttpURL constraintAnnotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        URI uri;
        if (value == null || value.length() == 0) {
            return true;
        }
        value = StringUtils.removeEnd((String)value, (String)"/");
        try {
            uri = new URI(value);
        }
        catch (URISyntaxException e) {
            return false;
        }
        try {
            uri.toURL();
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (StringUtils.isEmpty((String)uri.getHost())) {
            return false;
        }
        if (uri.getAuthority().endsWith(":")) {
            return false;
        }
        for (String component : new String[]{uri.getUserInfo(), uri.getQuery(), uri.getFragment()}) {
            if (StringUtils.isEmpty((String)component)) continue;
            return false;
        }
        String uriScheme = uri.getScheme();
        for (String scheme : REQUIRED_SCHEMES) {
            if (!scheme.equalsIgnoreCase(uriScheme)) continue;
            return true;
        }
        return false;
    }
}

