/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class AbstractChangesCommandParameters
extends AbstractCommandParameters {
    private final int maxChanges;
    private final Set<String> paths;

    protected AbstractChangesCommandParameters(int maxChanges, Set<String> paths) {
        this.maxChanges = maxChanges;
        this.paths = paths;
    }

    public int getMaxChanges() {
        return this.maxChanges;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    public boolean hasPaths() {
        return !this.paths.isEmpty();
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        protected int maxChanges;

        protected AbstractBuilder() {
        }

        public B maxChanges(int value) {
            this.maxChanges = value;
            return this.self();
        }

        public B path(String value) {
            AbstractChangesCommandParameters.addIf(NOT_BLANK, this.paths, value);
            return this.self();
        }

        public B paths(Iterable<String> values) {
            AbstractChangesCommandParameters.addIf(NOT_BLANK, this.paths, values);
            return this.self();
        }

        public B paths(String value, String ... values) {
            AbstractChangesCommandParameters.addIf(NOT_BLANK, this.paths, value, values);
            return this.self();
        }

        protected abstract B self();
    }
}

