/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.mail;

import com.atlassian.stash.validation.OptionalString;
import com.atlassian.stash.validation.RequiredString;
import javax.annotation.Nonnull;
import org.hibernate.validator.constraints.Range;

public class MailHostConfiguration {
    @RequiredString
    private final String hostname;
    @Range(min=0L, max=65535L)
    private final Integer port;
    @OptionalString
    private final String username;
    @OptionalString
    private final String password;
    private final boolean useTls;

    public MailHostConfiguration(String hostname, Integer port, String username, String password, boolean useTls) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.useTls = useTls;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailHostConfiguration that = (MailHostConfiguration)o;
        if (this.useTls != that.useTls) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.useTls ? 1 : 0);
        return result;
    }

    public static class Builder {
        private String hostname;
        private Integer port;
        private String username;
        private String password;
        private boolean useTls;

        public Builder() {
        }

        public Builder(@Nonnull MailHostConfiguration other) {
            this.hostname(other.hostname).port(other.port).username(other.username).useTls(other.useTls).password(other.password);
        }

        @Nonnull
        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Nonnull
        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        @Nonnull
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @Nonnull
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Nonnull
        public Builder useTls(boolean useTls) {
            this.useTls = useTls;
            return this;
        }

        @Nonnull
        public MailHostConfiguration build() {
            return new MailHostConfiguration(this.hostname, this.port, this.username, this.password, this.useTls);
        }
    }
}

